/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.ExtOpenSearchService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.ReindexAction;
import de.virtimo.bpc.core.replicator.ReindexActionException;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.service.OpenSearchSettingsCleaner;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="opensearch")
public class OpenSearchEndpoint {
    private static final Logger LOG = Logger.getLogger(OpenSearchEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ExtOpenSearchService> extopenSearchServiceTracker;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private static final Object REINDEXING_LOCK = new Object();
    private final Map<String, String> currentlyReindexing;

    public OpenSearchEndpoint(BundleContext bundleContext) {
        LOG.info("OpenSearchEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.currentlyReindexing = new HashMap<String, String>();
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.extopenSearchServiceTracker = new BpcServicesTracker<ExtOpenSearchService>(this.bundleContext, ExtOpenSearchService.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_LIST_INDICES", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response listIndices(@Context HttpHeaders hh) {
        LOG.info("listIndices");
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            Map<String, IndexInfo> indexInfos = oss.getIndexInfos();
            Object object = REINDEXING_LOCK;
            synchronized (object) {
                for (String reindexSource : this.currentlyReindexing.keySet()) {
                    String reindexTarget = this.currentlyReindexing.get(reindexSource);
                    if (reindexSource != null && indexInfos.containsKey(reindexSource)) {
                        IndexInfo reindexSourceIndexInfo = indexInfos.get(reindexSource);
                        reindexSourceIndexInfo.setReindexRunning(true);
                    }
                    if (reindexTarget == null || !indexInfos.containsKey(reindexTarget)) continue;
                    IndexInfo reindexTargetIndexInfo = indexInfos.get(reindexTarget);
                    reindexTargetIndexInfo.setReindexRunning(true);
                }
            }
            return Response.ok(indexInfos.values()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @Path(value="/indices/compact")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getCompactIndicesList(@Context HttpHeaders hh) {
        LOG.info("getCompactIndicesList");
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            HashMap<String, Set> result = new HashMap<String, Set>();
            Map<String, IndexInfo> indexInfos = oss.getIndexInfos();
            for (String indexName : indexInfos.keySet()) {
                IndexInfo indexInfo = indexInfos.get(indexName);
                if (!indexInfo.isInState("open") || indexName.startsWith(".") || indexInfo.isHidden()) continue;
                if (indexInfo.getAliases().isEmpty()) {
                    result.put(indexName, new HashSet());
                    continue;
                }
                for (String alias2 : indexInfo.getAliases()) {
                    if (result.containsKey(alias2)) {
                        Set alreadySetAlternativeNames = (Set)result.get(alias2);
                        alreadySetAlternativeNames.add(indexName);
                        continue;
                    }
                    HashSet<String> alternativeNames = new HashSet<String>();
                    alternativeNames.add(indexName);
                    result.put(alias2, alternativeNames);
                }
            }
            ArrayList resultList = new ArrayList();
            result.forEach((alias, indices) -> {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("alias", alias);
                entry.put("indices", indices);
                resultList.add(entry);
            });
            return Response.ok(resultList).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_GET_MAPPING", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/mapping/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getMapping(@PathParam(value="indexName") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getMapping indexName=" + indexName);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.put("settings", oss.getSettings(indexName));
            result.put("mappings", oss.getMapping(indexName));
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_DELETE_INDEX", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/operations/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response deleteIndex(@PathParam(value="indexName") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteIndex indexName=" + indexName);
        try {
            ExtOpenSearchService extOpenSearchService = this.extopenSearchServiceTracker.getService();
            try {
                extOpenSearchService.deleteIndex(indexName, userSession);
                return Response.ok((Object)("Index " + indexName + " successfully deleted")).build();
            }
            catch (OpenSearchRelatedException ex) {
                return Response.serverError().status(500).entity((Object)("Index " + indexName + " was not deleted")).build();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to delete the index '" + indexName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_REINDEX", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/reindex/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getReindexIndexInfo(@PathParam(value="indexName") String indexName, @QueryParam(value="copyIndexMapping") @DefaultValue(value="true") boolean copyIndexMapping, @QueryParam(value="copyMetaData") @DefaultValue(value="true") boolean copyMetaData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getReindexIndexInfo indexName=" + indexName + ", copyIndexMapping=" + copyIndexMapping + ", copyMetaData=" + copyMetaData);
        Object object = REINDEXING_LOCK;
        synchronized (object) {
            if (this.currentlyReindexing.containsKey(indexName)) {
                return ErrorResponse.forException(new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALREADY_STARTED, "Reindex of index '${index}' is already running.", MapUtil.mapOf("index", indexName))).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
            }
        }
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            LogServiceModule logServiceModule = (LogServiceModule)moduleManager.getModuleById("logservice");
            Set<String> aliasesForIndexName = oss.getAliasesForIndexName(indexName);
            List<ReplicationJob> relatedReplicationJobs = replicationManager.getJobsUsingTargetIndexAliases(aliasesForIndexName);
            List<LogServiceModuleInstance> relatedLogServices = logServiceModule.getLogServicesUsingTargetIndexAliases(aliasesForIndexName);
            Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
            ReindexAction reindexAction = new ReindexAction(this.bundleContext, oss, indexName, copyIndexMapping, copyMetaData, false, defaultIndexCreationSettings, defaultDynamicTemplates);
            reindexAction.setRelatedReplicationJobs(relatedReplicationJobs);
            reindexAction.setRelatedLogServices(relatedLogServices);
            Object result = "";
            result = (String)result + "{";
            result = (String)result + "  \"source\": {";
            result = (String)result + "    \"settings\":" + this.createMapOrderedByKeysAsJsonString(OpenSearchSettingsCleaner.clearSettingsMapFromKnownPrivateSettings(reindexAction.getSourceIndexSettings()));
            result = (String)result + "    ,";
            result = (String)result + "    \"mappings\":" + this.createMapOrderedByKeysAsJsonString(reindexAction.getSourceIndexMappings());
            result = (String)result + "  },";
            result = (String)result + "  \"target\": {";
            result = (String)result + "    \"settings\":" + this.createMapOrderedByKeysAsJsonString(OpenSearchSettingsCleaner.clearSettingsMapFromKnownPrivateSettings(reindexAction.getIndexSettingsOfTemporarilyCreateTargetIndex()));
            result = (String)result + "    ,";
            result = (String)result + "    \"mappings\":" + this.createMapOrderedByKeysAsJsonString(reindexAction.getTargetIndexMappings());
            result = (String)result + "  }";
            result = (String)result + "}";
            return Response.ok((Object)result).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the reindex infos of the index '" + indexName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private String createMapOrderedByKeysAsJsonString(Map<String, ?> map) throws JsonProcessingException {
        ObjectMapper om = ObjectMapperPool.createCustomizedObjectMapper();
        om.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return om.writeValueAsString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_REINDEX", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/reindex/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response reindexIndex(@PathParam(value="indexName") String indexName, @QueryParam(value="copyIndexMapping") @DefaultValue(value="true") boolean copyIndexMapping, @QueryParam(value="copyMetaData") @DefaultValue(value="true") boolean copyMetaData, @QueryParam(value="deleteSourceIndexAfterwards") @DefaultValue(value="false") boolean deleteSourceIndexAfterwards, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("reindexIndex indexName=" + indexName + ", copyIndexMapping=" + copyIndexMapping + ", copyMetaData=" + copyMetaData + ", deleteSourceIndexAfterwards=" + deleteSourceIndexAfterwards);
        Object object = REINDEXING_LOCK;
        synchronized (object) {
            if (this.currentlyReindexing.containsKey(indexName)) {
                return ErrorResponse.forException(new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALREADY_STARTED, "Reindex of index '${index}' is already running.", MapUtil.mapOf("index", indexName))).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
            }
            this.currentlyReindexing.put(indexName, null);
        }
        try {
            Response response;
            block28: {
                boolean mustStopRelatedReplicationJobs;
                OpenSearchService oss = this.openSearchServiceTracker.getService();
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                ModuleManager moduleManager = this.moduleManagerTracker.getService();
                CoreModule coreModule = moduleManager.getModuleByClass(CoreModule.class);
                LogServiceModule logServiceModule = moduleManager.getModuleByClass(LogServiceModule.class);
                Set<String> aliasesForIndexName = oss.getAliasesForIndexName(indexName);
                List<ReplicationJob> relatedReplicationJobs = replicationManager.getJobsUsingTargetIndexAliases(aliasesForIndexName);
                List<LogServiceModuleInstance> relatedLogServices = logServiceModule.getLogServicesUsingTargetIndexAliases(aliasesForIndexName);
                boolean bl = mustStopRelatedReplicationJobs = !coreModule.isMaintenanceModeEnabled() && coreModule.isMasterServer();
                if (mustStopRelatedReplicationJobs) {
                    for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                        replicationManager.stopReplicationJob(relatedReplicationJob.getId());
                        SystemAuditLog.info("ReplicationJobStopped", "Replication job '" + relatedReplicationJob.getId() + "' stopped. Caused by reindex action of index '" + indexName + "'.");
                    }
                }
                Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
                List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
                ReindexAction reindexAction = new ReindexAction(this.bundleContext, oss, indexName, copyIndexMapping, copyMetaData, deleteSourceIndexAfterwards, defaultIndexCreationSettings, defaultDynamicTemplates);
                reindexAction.setRelatedReplicationJobs(relatedReplicationJobs);
                reindexAction.setRelatedLogServices(relatedLogServices);
                response = REINDEXING_LOCK;
                synchronized (response) {
                    this.currentlyReindexing.put(indexName, reindexAction.getTargetIndexName());
                }
                try {
                    reindexAction.perform();
                    UserAuditLog.info(userSession, "OpenSearchIndexReindexed", "OpenSearch index '" + reindexAction.getSourceIndexName() + "' with the alias '" + reindexAction.getAliasName() + "' reindexed to '" + reindexAction.getTargetIndexName() + "'.", (Object)reindexAction.getSourceIndexName(), (Object)reindexAction.getTargetIndexName());
                    if (!mustStopRelatedReplicationJobs) break block28;
                }
                catch (Throwable throwable) {
                    if (mustStopRelatedReplicationJobs) {
                        for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                            replicationManager.startReplicationJob(relatedReplicationJob);
                            SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by reindex action of index '" + indexName + "'.");
                        }
                    }
                    throw throwable;
                }
                for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                    replicationManager.startReplicationJob(relatedReplicationJob);
                    SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by reindex action of index '" + indexName + "'.");
                }
            }
            response = Response.ok((Object)("Index " + indexName + " successfully reindexed")).build();
            return response;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to reindex the index '" + indexName + "'.", ex);
            Response response = ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
            return response;
        }
        finally {
            Object object2 = REINDEXING_LOCK;
            synchronized (object2) {
                this.currentlyReindexing.remove(indexName);
            }
        }
    }
}

