/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.response.BpcStatus;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BpcStatusUserImpl
implements BpcStatus {
    private static final Logger LOG = Logger.getLogger(BpcStatusUserImpl.class.getName());
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
    protected BundleContext bundleContext;
    protected ModuleManager moduleManager;
    protected CoreBundleConfiguration coreBundleConfiguration;
    protected LicenseService licenseService;

    public BpcStatusUserImpl(BundleContext bundleContext, ModuleManager moduleManager, CoreBundleConfiguration coreBundleConfiguration, LicenseService licenseService) {
        this.bundleContext = bundleContext;
        this.moduleManager = moduleManager;
        this.coreBundleConfiguration = coreBundleConfiguration;
        this.licenseService = licenseService;
    }

    @Override
    public String getServerUUID() {
        return this.coreBundleConfiguration.getServerUUID();
    }

    public String getBpcName() {
        return this.coreBundleConfiguration.getBpcName();
    }

    public List getLoadedModules() {
        ArrayList moduleInfos = new ArrayList();
        if (this.moduleManager != null) {
            for (Module m : this.moduleManager.getLoadedModules().values()) {
                HashMap<String, String> moduleInfoMap = new HashMap<String, String>();
                moduleInfoMap.put("id", m.getModuleId());
                moduleInfoMap.put("version", m.getModuleBundle().getVersion().toString());
                moduleInfos.add(moduleInfoMap);
            }
        }
        return moduleInfos;
    }

    public List getAllBpcModules() {
        LOG.finest("getAllBpcModules");
        ArrayList<Map<String, Object>> bpcModules = new ArrayList<Map<String, Object>>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!BpcBundleUtil.isBpcBundle(bundle)) continue;
            bpcModules.add(this.getBundleMap(bundle));
        }
        return bpcModules;
    }

    protected Map<String, Object> getBundleMap(Bundle bundle) {
        HashMap<String, Object> bundleMap = new HashMap<String, Object>();
        bundleMap.put("name", bundle.getHeaders().get("Bundle-Name"));
        bundleMap.put("version", bundle.getVersion());
        bundleMap.put("id", bundle.getBundleId());
        bundleMap.put("build", bundle.getHeaders().get("BPC-Build"));
        return bundleMap;
    }

    public static String formattedDate(Date date) {
        try {
            if (date == null || date.getTime() == 0L) {
                return "---";
            }
            return dateFormat.format(date);
        }
        catch (Exception ex) {
            return "---";
        }
    }

    public static String formattedDate(LocalDate date) {
        try {
            return BpcStatusUserImpl.formattedDate(Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        }
        catch (Exception ex) {
            return "---";
        }
    }

    public static String formattedDate(LocalDateTime dateTime) {
        try {
            return BpcStatusUserImpl.formattedDate(Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        catch (Exception ex) {
            return "---";
        }
    }
}

