/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.core.resource.response.SettingsBasedModuleConfigImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SettingsBasedConfigImpl
implements GlobalConfig {
    private static final Logger LOG = Logger.getLogger(SettingsBasedConfigImpl.class.getName());
    private final ModuleManager moduleManager;
    private final BpcIndexInfo fromIndex;
    private final int modelVersion;
    private final Settings allSettings;

    public SettingsBasedConfigImpl(ModuleManager moduleManager, BpcIndexInfo fromIndex, int modelVersion, Settings allSettings) {
        this.moduleManager = moduleManager;
        this.fromIndex = fromIndex;
        this.modelVersion = modelVersion;
        this.allSettings = allSettings;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getMetadata() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("modelVersion", this.modelVersion);
        result.put("fromIndex", this.fromIndex);
        return result;
    }

    @Override
    @JsonProperty(value="modules")
    public List<ModuleConfig> getModules() {
        ArrayList<ModuleConfig> result = new ArrayList<ModuleConfig>();
        Set<String> moduleIDs = this.allSettings.getModuleIDs();
        for (String moduleID : moduleIDs) {
            Module module = this.moduleManager.getModule(moduleID);
            if (module == null) {
                LOG.warning("Found settings for a module that is not available: " + moduleID);
            }
            Settings allSettingsOfModule = this.allSettings.getSettingsOfModuleId(moduleID);
            result.add(new SettingsBasedModuleConfigImpl(moduleID, module, allSettingsOfModule));
        }
        return result;
    }
}

