/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.api.response.ModuleInstanceConfig;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.core.resource.response.SimpleModuleInstanceConfigImpl;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleModuleConfigImpl
implements ModuleConfig {
    private static final Logger LOG = Logger.getLogger(SimpleModuleConfigImpl.class.getName());
    protected Module module;

    public SimpleModuleConfigImpl(Module module) {
        this.module = module;
    }

    @Override
    public String getModuleId() {
        return this.module.getModuleId();
    }

    @Override
    public String getModuleName() {
        return this.module.getModuleName();
    }

    @Override
    public List<Setting> getSettings() {
        LOG.log(Level.FINEST, "getSettings");
        return new MaskPasswords().maskPasswords(this.module.getConfiguration().getSettings().values());
    }

    @Override
    public Object getDefaultConfiguration() throws SettingException {
        LOG.info("getDefaultConfiguration");
        ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModule(this.module);
        return new ArrayList<Setting>(defaultConfig.getSettings().values());
    }

    @Override
    public List<ModuleConfig> getInstances() {
        LOG.info("getInstances");
        ArrayList<ModuleInstanceConfig> result = null;
        if (this.module instanceof InstantiableModule) {
            result = new ArrayList<ModuleInstanceConfig>();
            InstantiableModule instantiableModule = (InstantiableModule)this.module;
            for (ModuleInstance moduleInstance : instantiableModule.getModuleInstances().values()) {
                result.add(this.createModuleInstanceConfig(moduleInstance));
            }
        }
        return result;
    }

    protected ModuleInstanceConfig createModuleInstanceConfig(ModuleInstance moduleInstance) {
        LOG.log(Level.FINEST, "createModuleInstanceConfig");
        return new SimpleModuleInstanceConfigImpl(moduleInstance);
    }

    @Override
    public Object getInstancesDefaultConfiguration() throws SettingException {
        LOG.info("getInstancesDefaultConfiguration");
        if (this.module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)this.module;
            if (!instantiableModule.usesInstanceTypes()) {
                ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, "none");
                return new ArrayList<Setting>(defaultConfig.getSettings().values());
            }
            HashMap<String, ArrayList<Setting>> result = new HashMap<String, ArrayList<Setting>>();
            for (String supportedInstanceType : instantiableModule.getSupportedInstanceTypes()) {
                ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, supportedInstanceType);
                result.put(supportedInstanceType, new ArrayList<Setting>(defaultConfig.getSettings().values()));
            }
            return result;
        }
        return null;
    }
}

