/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.RestrictedSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.api.response.ModuleInstanceConfig;
import de.virtimo.bpc.core.resource.response.SettingValueFilter;
import de.virtimo.bpc.core.resource.response.SimpleModuleConfigImpl;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleInstanceConfigImpl;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class UserSessionBasedModuleConfigImpl
extends SimpleModuleConfigImpl {
    private static final Logger LOG = Logger.getLogger(UserSessionBasedModuleConfigImpl.class.getName());
    protected UserSession userSession;
    protected SettingValueFilter settingValueFilter;
    protected boolean embedInstances;
    protected boolean embedInstanceIDs;
    protected boolean onlySettingsMandatoryForFrontend;
    protected boolean embedDefaultConfigurations;
    protected boolean embedStorageServiceData;

    public UserSessionBasedModuleConfigImpl(Module module, UserSession userSession, boolean embedInstances, boolean embedInstanceIDs, boolean onlySettingsMandatoryForFrontend, boolean embedDefaultConfigurations, boolean embedStorageServiceData) {
        super(module);
        this.userSession = userSession;
        this.settingValueFilter = new SettingValueFilter(userSession);
        this.embedInstances = embedInstances;
        this.embedInstanceIDs = embedInstanceIDs;
        this.onlySettingsMandatoryForFrontend = onlySettingsMandatoryForFrontend;
        this.embedDefaultConfigurations = embedDefaultConfigurations;
        this.embedStorageServiceData = embedStorageServiceData;
    }

    @Override
    public List<Setting> getSettings() {
        return this.getFilteredSettingList(this.settingValueFilter.filter(super.getSettings()), this.onlySettingsMandatoryForFrontend);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getDefaultConfiguration() throws SettingException {
        return !this.embedDefaultConfigurations ? null : this.getFilteredDefaultConfiguration(super.getDefaultConfiguration(), false);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getInstancesDefaultConfiguration() throws SettingException {
        return !this.embedDefaultConfigurations ? null : this.getFilteredDefaultConfiguration(super.getInstancesDefaultConfiguration(), false);
    }

    private Object getFilteredDefaultConfiguration(Object unfilteredConfig, boolean onlySettingsMandatoryForFrontend) {
        if (unfilteredConfig instanceof List) {
            List settings = (List)unfilteredConfig;
            return this.getFilteredSettingList(settings, onlySettingsMandatoryForFrontend);
        }
        if (unfilteredConfig instanceof Map) {
            Map settingMap = (Map)unfilteredConfig;
            HashMap result = new HashMap();
            settingMap.forEach((key, value) -> result.put(key, this.getFilteredSettingList((List<Setting>)value, onlySettingsMandatoryForFrontend)));
            return result;
        }
        return unfilteredConfig;
    }

    private List<Setting> getFilteredSettingList(List<Setting> settings, boolean compact) {
        return UserSessionBasedModuleConfigImpl.getFilteredSettingList(this.userSession, settings, compact);
    }

    public static List<Setting> getFilteredSettingList(UserSession userSession, List<Setting> settings, boolean onlySettingsMandatoryForFrontend) {
        ArrayList<Setting> result = new ArrayList<Setting>();
        if (settings != null) {
            for (Setting setting : settings) {
                if (!(setting instanceof RestrictedSetting) || !((RestrictedSetting)setting).isReadableByRoles(userSession.getRoles())) continue;
                if (onlySettingsMandatoryForFrontend) {
                    if (!setting.getCustomFields().getBooleanValue("_mandatoryForFrontend", false)) continue;
                    result.add(setting);
                    continue;
                }
                result.add(setting);
            }
        }
        return result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="instancesCompact")
    public List<Map<String, Object>> getInstanceIDs() {
        LOG.info("getInstanceIDs");
        ArrayList<Map<String, Object>> result = null;
        if (this.embedInstanceIDs && this.module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)this.module;
            result = new ArrayList<Map<String, Object>>();
            for (ModuleInstance moduleInstance : instantiableModule.getUseableModuleInstances(this.userSession)) {
                result.add(MapUtil.mapOf("instanceId", moduleInstance.getModuleId(), "instanceType", moduleInstance.getInstanceType(), "instanceName", moduleInstance.getConfiguration().getSettingValue("module_name").asString("")));
            }
        }
        return result;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ModuleConfig> getInstances() {
        LOG.info("getInstances");
        ArrayList<ModuleInstanceConfig> result = null;
        if (this.embedInstances && this.module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)this.module;
            result = new ArrayList<ModuleInstanceConfig>();
            for (ModuleInstance moduleInstance : instantiableModule.getUseableModuleInstances(this.userSession)) {
                result.add(this.createModuleInstanceConfig(moduleInstance));
            }
        }
        return result;
    }

    @Override
    protected ModuleInstanceConfig createModuleInstanceConfig(ModuleInstance moduleInstance) {
        return new UserSessionBasedModuleInstanceConfigImpl(moduleInstance, this.userSession, this.onlySettingsMandatoryForFrontend, this.embedStorageServiceData);
    }
}

