/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.opensearch.plugin.OpenSearchHost;
import java.util.Objects;

public class OpenSearchHostImpl
implements OpenSearchHost {
    private final String schemeName;
    private final String hostName;
    private final int port;

    public static OpenSearchHost create(String hostString) {
        String text = hostString;
        String scheme = null;
        int schemeIdx = text.indexOf("://");
        if (schemeIdx > 0) {
            scheme = text.substring(0, schemeIdx);
            text = text.substring(schemeIdx + 3);
        }
        int port = -1;
        int portIdx = text.lastIndexOf(":");
        if (portIdx > 0) {
            try {
                port = Integer.parseInt(text.substring(portIdx + 1));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid hostString given: " + hostString);
            }
            text = text.substring(0, portIdx);
        }
        return new OpenSearchHostImpl(scheme, text, port);
    }

    public OpenSearchHostImpl(String schemeName, String hostName, int port) {
        this.schemeName = schemeName;
        this.hostName = hostName;
        this.port = port;
    }

    @Override
    public String getSchemeName() {
        return this.schemeName;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchHostImpl that = (OpenSearchHostImpl)o;
        return this.port == that.port && Objects.equals(this.schemeName, that.schemeName) && Objects.equals(this.hostName, that.hostName);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.hostName, this.port);
    }

    public String toString() {
        return "OpenSearchHostImpl{schemeName='" + this.schemeName + "', hostName='" + this.hostName + "', port=" + this.port + "}";
    }
}

