/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.core.service.OpenSearchBasicAuthData;
import de.virtimo.bpc.core.service.OpenSearchPrivateKeyData;
import de.virtimo.bpc.util.BpcKeyStore;
import de.virtimo.bpc.util.BpcTrustStore;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.opensearch.client.RestClientBuilder;
import org.osgi.framework.BundleContext;

public class OpenSearchHttpClientConfigCallback
implements RestClientBuilder.HttpClientConfigCallback {
    private static final Logger LOG = Logger.getLogger(OpenSearchHttpClientConfigCallback.class.getName());
    private final BundleContext bundleContext;
    private final OpenSearchBasicAuthData basicAuthData;
    private final boolean mustSetSslContext;
    private final OpenSearchPrivateKeyData privateKeyData;

    public OpenSearchHttpClientConfigCallback(BundleContext bundleContext, OpenSearchBasicAuthData basicAuthData, boolean mustSetSslContext, OpenSearchPrivateKeyData privateKeyData) {
        this.bundleContext = bundleContext;
        this.basicAuthData = basicAuthData;
        this.mustSetSslContext = mustSetSslContext;
        this.privateKeyData = privateKeyData;
    }

    @Override
    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
        if (this.basicAuthData != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.basicAuthData.getUserName(), this.basicAuthData.getPassword()));
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        if (this.mustSetSslContext) {
            if (this.bundleContext == null) {
                LOG.warning("Failed to set the SSL context to the OpenSearch client due to missing BundleContext. Maybe a unit test?");
            } else {
                try {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                    if (this.privateKeyData != null) {
                        char[] privateKeyPwd = this.privateKeyData.getPassword();
                        if (privateKeyPwd == null) {
                            privateKeyPwd = BpcKeyStore.getInstance().getPaxWebKeyStoreData(this.bundleContext).getKeyStorePassword();
                        }
                        KeyStore workaroundKeyStore = BpcKeyStore.getInstance().createWorkaroundKeyStore(this.bundleContext, this.privateKeyData.getAlias(), privateKeyPwd);
                        sslContextBuilder.loadKeyMaterial(workaroundKeyStore, privateKeyPwd);
                    }
                    sslContextBuilder.loadTrustMaterial(BpcTrustStore.getInstance().getTrustStore(this.bundleContext), null);
                    SSLContext sslContext = sslContextBuilder.build();
                    httpClientBuilder.setSSLContext(sslContext);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to set the pax web related truststore and/or keystore to the OpenSearch client.", ex);
                }
            }
        }
        return httpClientBuilder;
    }
}

