/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage;

import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.core.storage.StoreItemRestrictionFactory;
import de.virtimo.bpc.util.MapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StoreItemFactory {
    private static final Logger LOG = Logger.getLogger(StoreItemFactory.class.getName());

    public static StoreItem create(String id, Map<String, Object> openSearchSource) {
        return StoreItem.withId(id).withModuleId(MapUtil.getValueAsString(openSearchSource, "moduleId", null)).withModuleInstanceId(MapUtil.getValueAsString(openSearchSource, "moduleInstanceId", null)).withName(MapUtil.getValueAsString(openSearchSource, "name", null)).withValue(MapUtil.getValueAsObject(openSearchSource, "value", null)).withFavorite(MapUtil.getValueAsBoolean(openSearchSource, "favorite", false)).withReadRestriction(StoreItemRestrictionFactory.create(MapUtil.getValueAsMap(openSearchSource, "readRestriction", null))).withWriteRestriction(StoreItemRestrictionFactory.create(MapUtil.getValueAsMap(openSearchSource, "writeRestriction", null))).withCustomFields(StoreItemFactory.extractAndMergeCustomFields(openSearchSource)).build();
    }

    private static Map<String, Object> extractAndMergeCustomFields(Map<String, Object> openSearchSource) {
        HashMap oldCustomFields = new HashMap();
        if (openSearchSource.containsKey("customFields")) {
            oldCustomFields.putAll(MapUtil.getValueAsMap(openSearchSource, "customFields", Map.of()));
        }
        HashMap<String, Object> newCustomFields = new HashMap<String, Object>(openSearchSource);
        newCustomFields.remove("id");
        newCustomFields.remove("moduleId");
        newCustomFields.remove("moduleInstanceId");
        newCustomFields.remove("name");
        newCustomFields.remove("value");
        newCustomFields.remove("favorite");
        newCustomFields.remove("readRestriction");
        newCustomFields.remove("writeRestriction");
        newCustomFields.remove("customFields");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(oldCustomFields);
        result.putAll(newCustomFields);
        return result;
    }

    static final class Field {
        static final String Id = "id";
        static final String ModuleId = "moduleId";
        static final String ModuleInstanceId = "moduleInstanceId";
        static final String Name = "name";
        static final String Value = "value";
        static final String Favorite = "favorite";
        static final String ReadRestriction = "readRestriction";
        static final String WriteRestriction = "writeRestriction";
        static final String CustomFields = "customFields";

        Field() {
        }
    }
}

