/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.FlowService;
import de.virtimo.bpc.core.auth.CsrfTokenException;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

@Path(value="flow")
public class FlowEndpoint {
    private static final Logger LOG = Logger.getLogger(FlowEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<FlowService> flowServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CsrfTokenService> csrfTokenServiceTracker;

    public FlowEndpoint(BundleContext bundleContext) {
        LOG.info("FlowEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.flowServiceTracker = new BpcServicesTracker<FlowService>(this.bundleContext, FlowService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.csrfTokenServiceTracker = new BpcServicesTracker<CsrfTokenService>(this.bundleContext, CsrfTokenService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private void checkCsrfToken(HttpServletRequest req, UserSession userSession, String instanceId) throws CsrfTokenException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.log(Level.FINEST, "checkCsrfToken req=..., instanceId=" + instanceId);
        if (this.flowServiceTracker.getService().getConfig(instanceId).getSettingValue("checkCsrfToken").asBoolean(true) && !this.csrfTokenServiceTracker.getService().isValidRequest(req, userSession)) {
            throw new CsrfTokenException();
        }
    }

    @GET
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    public Response flowGet(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") @DefaultValue(value="") String targetUrl, @QueryParam(value="forceJson") @DefaultValue(value="false") boolean forceJson, @Context HttpServletRequest req, @Context UriInfo uriInfo, @Context UserSession userSession, @Context HttpHeaders headers) {
        LOG.info("flowGet : instanceId=" + instanceId + ", uriInfo=" + uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.flowServiceTracker.getService().doGet(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception backend connection: ", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    public Response flowPost(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOG.info("flowPost : instanceId=" + instanceId + ", uriInfo=" + uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.flowServiceTracker.getService().doPost(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception on flow post.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    public Response flowPut(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOG.info("flowPut : instanceId=" + instanceId + ", uriInfo=" + uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.flowServiceTracker.getService().doPut(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception ony flow put.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    public Response flowDelete(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession) {
        LOG.info("flowDelete : instanceId=" + instanceId + ", uriInfo=" + uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.flowServiceTracker.getService().doDelete(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception on flow delete.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

