/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.CsrfTokenException;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.core.auth.IpPinningException;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.resource.AuthenticationEndpoint;
import de.virtimo.bpc.core.resource.BpcCookieCreator;
import de.virtimo.bpc.core.resource.CookiesList;
import de.virtimo.bpc.jaxrs.BasicAuthCredentialsProvider;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcHardcodedBasicAuthentication;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.util.MapUtil;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.osgi.framework.BundleContext;

public class BpcJAXRSInvoker
extends JAXRSInvoker {
    private static final Logger LOG = Logger.getLogger(BpcJAXRSInvoker.class.getName());
    private BundleContext bundleContext = null;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<IpPinningService> ipPinningServiceTracker;
    private BpcServicesTracker<CsrfTokenService> csrfTokenServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public BpcJAXRSInvoker(BundleContext bundleContext) {
        LOG.info("BpcJAXRSInvoker bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.ipPinningServiceTracker = new BpcServicesTracker<IpPinningService>(this.bundleContext, IpPinningService.class);
        this.csrfTokenServiceTracker = new BpcServicesTracker<CsrfTokenService>(this.bundleContext, CsrfTokenService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object requestParams, Object resourceObject) {
        HttpHeaders httpHeaders;
        Method method;
        block69: {
            String requiredRight;
            boolean ipPinningCheckAlreadyDone;
            boolean skipIpPinningCheck;
            boolean csrfTokenCheckAlreadyDone;
            boolean skipCsrfTokenCheck;
            block67: {
                UserSession userSession;
                HttpServletRequest httpServletRequest;
                String errorMessage;
                block65: {
                    block63: {
                        UserSession userSession2;
                        HttpServletRequest httpServletRequest2;
                        block61: {
                            LOG.info("invoke exchange=" + exchange + ", requestParams=..., resourceObject=" + resourceObject);
                            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
                            method = ori.getMethodToInvoke();
                            skipCsrfTokenCheck = false;
                            csrfTokenCheckAlreadyDone = false;
                            skipIpPinningCheck = false;
                            ipPinningCheckAlreadyDone = false;
                            if (method.isAnnotationPresent(BpcEndpoint.class)) {
                                httpHeaders = this.getHttpHeaders(exchange);
                                try {
                                    BpcEndpoint bpcEndpointAnnotation = method.getAnnotation(BpcEndpoint.class);
                                    skipIpPinningCheck = bpcEndpointAnnotation.skipIpPinningCheck();
                                    httpServletRequest2 = this.getHttpServletRequest(exchange);
                                    if (httpServletRequest2 == null || (userSession2 = this.clientSessionManagerTracker.getService().getUserSession(httpServletRequest2)) == null || skipIpPinningCheck || ipPinningCheckAlreadyDone) break block61;
                                    try {
                                        this.checkIpPinning(exchange, userSession2);
                                    }
                                    finally {
                                        ipPinningCheckAlreadyDone = true;
                                    }
                                }
                                catch (Exception ex) {
                                    LOG.log(Level.SEVERE, "BPC endpoint check failed.", ex);
                                    return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).cookies(this.createErrorResponseCookies(ex)).build()});
                                }
                            }
                        }
                        if (method.isAnnotationPresent(BpcUserSessionRequired.class)) {
                            httpHeaders = this.getHttpHeaders(exchange);
                            try {
                                BpcUserSessionRequired userSessionRequiredAnnotation = method.getAnnotation(BpcUserSessionRequired.class);
                                skipCsrfTokenCheck = !userSessionRequiredAnnotation.skipCsrfCheck().equalsIgnoreCase("false");
                                httpServletRequest2 = this.getHttpServletRequest(exchange);
                                if (httpServletRequest2 == null) {
                                    throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpServletRequest to do the user session check.");
                                }
                                userSession2 = this.clientSessionManagerTracker.getService().getUserSession(httpServletRequest2);
                                if (userSession2 == null) {
                                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                                }
                                this.checkIfUserCanAccessBPC(userSession2);
                                if (!skipCsrfTokenCheck && !csrfTokenCheckAlreadyDone) {
                                    try {
                                        this.checkCsrfToken(exchange, userSession2);
                                    }
                                    finally {
                                        csrfTokenCheckAlreadyDone = true;
                                    }
                                }
                                if (skipIpPinningCheck || ipPinningCheckAlreadyDone) break block63;
                                try {
                                    this.checkIpPinning(exchange, userSession2);
                                }
                                finally {
                                    ipPinningCheckAlreadyDone = true;
                                }
                            }
                            catch (Exception ex) {
                                LOG.log(Level.SEVERE, "BPC user session check failed.", ex);
                                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).cookies(this.createErrorResponseCookies(ex)).build()});
                            }
                        }
                    }
                    if (method.isAnnotationPresent(BpcRoleRequired.class)) {
                        httpHeaders = this.getHttpHeaders(exchange);
                        try {
                            BpcRoleRequired roleRequiredAnnotation = method.getAnnotation(BpcRoleRequired.class);
                            String requiredRole = roleRequiredAnnotation.role();
                            errorMessage = roleRequiredAnnotation.message();
                            httpServletRequest = this.getHttpServletRequest(exchange);
                            if (httpServletRequest == null) {
                                throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpServletRequest to do the user role check.");
                            }
                            userSession = this.clientSessionManagerTracker.getService().getUserSession(httpServletRequest);
                            if (userSession == null) {
                                throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                            }
                            this.checkIfUserCanAccessBPC(userSession);
                            if (!userSession.hasRole(requiredRole)) {
                                throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, errorMessage, MapUtil.mapOf("requiredRole", requiredRole));
                            }
                            if (!skipCsrfTokenCheck && !csrfTokenCheckAlreadyDone) {
                                try {
                                    this.checkCsrfToken(exchange, userSession);
                                }
                                finally {
                                    csrfTokenCheckAlreadyDone = true;
                                }
                            }
                            if (skipIpPinningCheck || ipPinningCheckAlreadyDone) break block65;
                            try {
                                this.checkIpPinning(exchange, userSession);
                            }
                            finally {
                                ipPinningCheckAlreadyDone = true;
                            }
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "BPC role check failed.", ex);
                            return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).cookies(this.createErrorResponseCookies(ex)).build()});
                        }
                    }
                }
                if (method.isAnnotationPresent(BpcRightRequired.class)) {
                    httpHeaders = this.getHttpHeaders(exchange);
                    try {
                        BpcRightRequired rightRequiredAnnotation = method.getAnnotation(BpcRightRequired.class);
                        requiredRight = rightRequiredAnnotation.right();
                        errorMessage = rightRequiredAnnotation.message();
                        httpServletRequest = this.getHttpServletRequest(exchange);
                        if (httpServletRequest == null) {
                            throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpServletRequest to do the user right check.");
                        }
                        userSession = this.clientSessionManagerTracker.getService().getUserSession(httpServletRequest);
                        if (userSession == null) {
                            throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                        }
                        this.checkIfUserCanAccessBPC(userSession);
                        if (!userSession.hasRight(requiredRight)) {
                            throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_RIGHT_CHECK_FAILED, errorMessage, MapUtil.mapOf("requiredRight", requiredRight));
                        }
                        if (!skipCsrfTokenCheck && !csrfTokenCheckAlreadyDone) {
                            try {
                                this.checkCsrfToken(exchange, userSession);
                            }
                            finally {
                                csrfTokenCheckAlreadyDone = true;
                            }
                        }
                        if (skipIpPinningCheck || ipPinningCheckAlreadyDone) break block67;
                        try {
                            this.checkIpPinning(exchange, userSession);
                        }
                        finally {
                            ipPinningCheckAlreadyDone = true;
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "BPC right check failed.", ex);
                        return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).cookies(this.createErrorResponseCookies(ex)).build()});
                    }
                }
            }
            if (method.isAnnotationPresent(BpcRoleOrRightRequired.class)) {
                httpHeaders = this.getHttpHeaders(exchange);
                try {
                    BpcRoleOrRightRequired roleOrRightRequiredAnnotation = method.getAnnotation(BpcRoleOrRightRequired.class);
                    requiredRight = roleOrRightRequiredAnnotation.right();
                    String requiredRole = roleOrRightRequiredAnnotation.role();
                    String errorMessage = roleOrRightRequiredAnnotation.message();
                    HttpServletRequest httpServletRequest = this.getHttpServletRequest(exchange);
                    if (httpServletRequest == null) {
                        throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpServletRequest to do the user role or right check.");
                    }
                    UserSession userSession = this.clientSessionManagerTracker.getService().getUserSession(httpServletRequest);
                    if (userSession == null) {
                        throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "User session missing.");
                    }
                    this.checkIfUserCanAccessBPC(userSession);
                    if (!userSession.hasRight(requiredRight) && !userSession.hasRole(requiredRole)) {
                        throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_RIGHT_CHECK_FAILED, errorMessage, MapUtil.mapOf("requiredRight", requiredRight, "requiredRole", requiredRole));
                    }
                    if (!skipCsrfTokenCheck && !csrfTokenCheckAlreadyDone) {
                        try {
                            this.checkCsrfToken(exchange, userSession);
                        }
                        finally {
                            csrfTokenCheckAlreadyDone = true;
                        }
                    }
                    if (skipIpPinningCheck || ipPinningCheckAlreadyDone) break block69;
                    try {
                        this.checkIpPinning(exchange, userSession);
                    }
                    finally {
                        ipPinningCheckAlreadyDone = true;
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "BPC role or right check failed.", ex);
                    return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).cookies(this.createErrorResponseCookies(ex)).build()});
                }
            }
        }
        if (method.isAnnotationPresent(BpcHardcodedBasicAuthentication.class)) {
            httpHeaders = null;
            try {
                BpcHardcodedBasicAuthentication hardcodedBasicAuthenticationAnnotation = method.getAnnotation(BpcHardcodedBasicAuthentication.class);
                String hardcodedUsername = hardcodedBasicAuthenticationAnnotation.username();
                String hardcodedPassword = hardcodedBasicAuthenticationAnnotation.password();
                httpHeaders = this.getHttpHeaders(exchange);
                PasswordAuthentication basicAuthCredentials = BasicAuthCredentialsProvider.getBasicAuthCredentials(httpHeaders);
                if (basicAuthCredentials == null || !hardcodedUsername.equals(basicAuthCredentials.getUserName()) || !hardcodedPassword.equals(new String(basicAuthCredentials.getPassword()))) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Basic auth check failed.", ex);
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        return super.invoke(exchange, requestParams, resourceObject);
    }

    private NewCookie[] createErrorResponseCookies(Exception ex) {
        if (ex instanceof IpPinningException) {
            String bpcCookieName = AuthenticationEndpoint.getBpcCookieName(this.coreBundleConfigurationTracker);
            String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
            BpcCookieCreator bpcCookieCreator = new BpcCookieCreator(bpcCookieName, bpcClientPath);
            NewCookie deleteCookie = bpcCookieCreator.createDeleteCookie();
            return CookiesList.add(deleteCookie).asArray();
        }
        return null;
    }

    private void checkIfUserCanAccessBPC(UserSession userSession) throws SystemException {
        CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
        if (!coreModule.isUserAllowedToAccessBPC(userSession)) {
            throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, "Mandatory role to access BPC is missing.");
        }
    }

    private void checkCsrfToken(Exchange exchange, UserSession userSession) throws CsrfTokenException, ServiceNotFoundException {
        HttpServletRequest relatedServletRequest = this.getHttpServletRequest(exchange);
        if (relatedServletRequest == null) {
            LOG.log(Level.SEVERE, "Skipping the CSRF token check due to a missing http servlet request. Please inform the BPC developers. There must be a change due to a Karaf update.");
            return;
        }
        if (!this.csrfTokenServiceTracker.getService().isValidRequest(relatedServletRequest, userSession)) {
            throw new CsrfTokenException();
        }
    }

    private void checkIpPinning(Exchange exchange, UserSession userSession) throws IpPinningException, ServiceNotFoundException {
        HttpServletRequest relatedServletRequest = this.getHttpServletRequest(exchange);
        if (relatedServletRequest == null) {
            LOG.log(Level.SEVERE, "Skipping the IP pinning check due to a missing http servlet request. Please inform the BPC developers. There must be a change due to a Karaf update.");
            return;
        }
        if (!this.ipPinningServiceTracker.getService().isValidRequest(relatedServletRequest, userSession)) {
            throw new IpPinningException();
        }
    }

    private HttpHeaders getHttpHeaders(Exchange exchange) {
        LOG.info("getHttpHeaders exchange=" + exchange);
        Message inMessage = exchange.getInMessage();
        if (inMessage != null) {
            return new HttpHeadersImpl(inMessage);
        }
        return null;
    }

    private HttpServletRequest getHttpServletRequest(Exchange exchange) {
        LOG.info("getHttpServletRequest exchange=" + exchange);
        Message inMessage = exchange.getInMessage();
        if (inMessage != null) {
            return (HttpServletRequest)inMessage.get((Object)"HTTP.REQUEST");
        }
        return null;
    }
}

