/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.db;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.db.DatabaseTableData;
import de.virtimo.bpc.logservice.db.DatabaseTableDataCache;
import de.virtimo.bpc.logservice.db.PreparedStatementBuilder;
import de.virtimo.bpc.logservice.db.PreparedStatementData;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.logservice.resource.LogDataEntries;
import de.virtimo.bpc.util.MapUtil;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DatabaseLogService
implements LogService {
    private static final Logger LOG = Logger.getLogger(DatabaseLogService.class.getName());
    private final DatabaseManager databaseManager;
    private final DatabaseTableDataCache databaseTableDataCache;

    public DatabaseLogService(DatabaseManager databaseManager, DatabaseTableDataCache databaseTableDataCache) {
        this.databaseManager = databaseManager;
        this.databaseTableDataCache = databaseTableDataCache;
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, String timeZoneId, String parentQuery, String parentFilter) throws LogServiceException {
        LOG.info("deleteData moduleInstance=..., timeZoneId=" + timeZoneId + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Delete log data from database is not supported.");
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        LOG.info("deleteData moduleInstance=" + moduleInstance + ", parentIDs=" + parentIDs);
        Connection conn = null;
        HashMap<String, PreparedStatement> preparedStatementsCache = new HashMap<String, PreparedStatement>();
        try {
            LogServiceModuleInstance.RdmsConfig rdmsConfig = moduleInstance.getRdmsConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            boolean childProcessingEnabled = rdmsConfig.child != null && keysConfig.child != null;
            DataSource dataSource = this.databaseManager.getDataSource(rdmsConfig.rdmsDataSourceName);
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            List<String> parentKeys = keysConfig.parent.getIdColumnsAsList();
            if (parentKeys.size() != 1) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed. The parent keys setting should use only 1 key column.");
            }
            ArrayList<String> childKeys = null;
            if (childProcessingEnabled) {
                List<String> configuredChildKeys = keysConfig.child.getIdColumnsAsList();
                if (configuredChildKeys.size() != 2) {
                    throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed. The child keys setting must be 2 columns.");
                }
                childKeys = new ArrayList<String>();
                childKeys.add(configuredChildKeys.get(0));
            }
            DatabaseTableData parentTableData = this.databaseTableDataCache.getDatabaseTableData(rdmsConfig.rdmsDataSourceName, rdmsConfig.parent.table, conn);
            DatabaseTableData childTableData = null;
            if (childProcessingEnabled) {
                childTableData = this.databaseTableDataCache.getDatabaseTableData(rdmsConfig.rdmsDataSourceName, rdmsConfig.child.table, conn);
            }
            for (String parentId : parentIDs) {
                HashMap<String, Object> parentKeysData = new HashMap<String, Object>();
                parentKeysData.put(parentKeys.get(0), parentId);
                PreparedStatementBuilder parentPreparedStatementBuilder = new PreparedStatementBuilder(conn);
                PreparedStatementData parentSqlBuilderResult = parentPreparedStatementBuilder.createDeleteStatement(rdmsConfig.parent.table, parentKeysData, parentKeys);
                String parentSql = parentSqlBuilderResult.getSqlStatement();
                LOG.fine(parentSql);
                PreparedStatement parentStatement = this.filledPreparedStatement(conn, null, parentTableData, preparedStatementsCache, parentSqlBuilderResult.getOrderedColumnData(), parentSql);
                int deletedParentRows = parentStatement.executeUpdate();
                LOG.fine("deleted parent rows: " + deletedParentRows);
                if (!childProcessingEnabled) continue;
                HashMap<String, Object> childKeysData = new HashMap<String, Object>();
                childKeysData.put((String)childKeys.get(0), parentId);
                PreparedStatementBuilder childPreparedStatementBuilder = new PreparedStatementBuilder(conn);
                PreparedStatementData childSqlBuilderResult = childPreparedStatementBuilder.createDeleteStatement(rdmsConfig.child.table, childKeysData, childKeys);
                String childSql = childSqlBuilderResult.getSqlStatement();
                LOG.fine(childSql);
                PreparedStatement childStatement = this.filledPreparedStatement(conn, null, childTableData, preparedStatementsCache, childSqlBuilderResult.getOrderedColumnData(), childSql);
                int deletedChildRows = childStatement.executeUpdate();
                LOG.fine("deleted child rows: " + deletedChildRows);
            }
            LOG.info("Transaction is being committed");
            conn.commit();
        }
        catch (DataSourceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed. ${error}.", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, "Could not delete from the database.", ex);
            if (conn != null) {
                try {
                    LOG.info("Transaction is being rolled back");
                    conn.rollback();
                }
                catch (SQLException e) {
                    LOG.log(Level.SEVERE, "Could not rollback the database deletes", e);
                }
            }
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed due to database error: ${dbError}.", MapUtil.mapOf("dbError", ex.getMessage()), (Throwable)ex);
        }
        finally {
            for (PreparedStatement preparedStatement : preparedStatementsCache.values()) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Closing prepared statement failed.", ex);
                }
            }
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, "Closing database connection failed.", ex);
                }
            }
        }
        return null;
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOG.info("deleteChildData moduleInstance=..., parentId=" + parentId + ", timeZoneId=" + timeZoneId + ", childQuery=" + childQuery + ", childFilter=" + childFilter);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Delete child log data from database is not supported.");
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        LOG.info("deleteChildData moduleInstance=" + moduleInstance + ", parentId=" + parentId + ", childIDs=" + childIDs);
        Connection conn = null;
        HashMap<String, PreparedStatement> preparedStatementsCache = new HashMap<String, PreparedStatement>();
        try {
            boolean childProcessingEnabled;
            LogServiceModuleInstance.RdmsConfig rdmsConfig = moduleInstance.getRdmsConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            boolean bl = childProcessingEnabled = rdmsConfig.child != null && keysConfig.child != null;
            if (!childProcessingEnabled) {
                FutureTask<Exception> futureTask = null;
                return futureTask;
            }
            DataSource dataSource = this.databaseManager.getDataSource(rdmsConfig.rdmsDataSourceName);
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            List<String> childKeys = keysConfig.child.getIdColumnsAsList();
            if (childKeys.size() != 2) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed. The child keys setting must be 2 columns.");
            }
            DatabaseTableData childTableData = this.databaseTableDataCache.getDatabaseTableData(rdmsConfig.rdmsDataSourceName, rdmsConfig.child.table, conn);
            for (String childId : childIDs) {
                HashMap<String, Object> childKeysData = new HashMap<String, Object>();
                childKeysData.put(childKeys.get(0), parentId);
                childKeysData.put(childKeys.get(1), childId);
                PreparedStatementBuilder childPreparedStatementBuilder = new PreparedStatementBuilder(conn);
                PreparedStatementData childSqlBuilderResult = childPreparedStatementBuilder.createDeleteStatement(rdmsConfig.child.table, childKeysData, childKeys);
                String childSql = childSqlBuilderResult.getSqlStatement();
                LOG.fine(childSql);
                PreparedStatement childStatement = this.filledPreparedStatement(conn, null, childTableData, preparedStatementsCache, childSqlBuilderResult.getOrderedColumnData(), childSql);
                int deletedChildRows = childStatement.executeUpdate();
                LOG.fine("deleted child rows: " + deletedChildRows);
            }
            LOG.info("Transaction is being committed");
            conn.commit();
        }
        catch (DataSourceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed. ${error}.", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, "Could not delete from the database.", ex);
            if (conn != null) {
                try {
                    LOG.info("Transaction is being rolled back");
                    conn.rollback();
                }
                catch (SQLException e) {
                    LOG.log(Level.SEVERE, "Could not rollback the database deletes", e);
                }
            }
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_DELETE_FAILED, "Delete data failed due to database error: ${dbError}.", MapUtil.mapOf("dbError", ex.getMessage()), (Throwable)ex);
        }
        finally {
            for (PreparedStatement preparedStatement : preparedStatementsCache.values()) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Closing prepared statement failed.", ex);
                }
            }
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, "Closing database connection failed.", ex);
                }
            }
        }
        return null;
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOG.info("deleteChildData moduleInstance=..., timeZoneId=" + timeZoneId + ", childQuery=" + childQuery + ", childFilter=" + childFilter);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Delete child log data from database is not supported.");
    }

    @Override
    public FutureTask<Exception> logData(LogServiceModuleInstance moduleInstance, ZonedDateTime currentDateTime, LogData logData) throws LogServiceException {
        return this.logData(moduleInstance, currentDateTime, logData, null);
    }

    @Override
    public FutureTask<Exception> logData(LogServiceModuleInstance moduleInstance, ZonedDateTime currentDateTime, LogData logData, ExternalReferenceData externalReferenceData) throws LogServiceException {
        LOG.info("logData moduleInstance=" + moduleInstance + ", currentDateTime=" + currentDateTime + ", logData=..., externalReferenceData=...");
        Connection conn = null;
        HashMap<String, PreparedStatement> preparedStatementsCache = new HashMap<String, PreparedStatement>();
        try {
            LogServiceModuleInstance.RdmsConfig rdmsConfig = moduleInstance.getRdmsConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            LogServiceModuleInstance.FieldsConfig fieldsConfig = moduleInstance.getFieldsConfig();
            boolean childProcessingEnabled = rdmsConfig.child != null && keysConfig.child != null;
            DataSource dataSource = this.databaseManager.getDataSource(rdmsConfig.rdmsDataSourceName);
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            ZoneId databaseZoneId = rdmsConfig.getRdmsTimeZoneAsZoneId();
            DatabaseTableData parentTableData = this.databaseTableDataCache.getDatabaseTableData(rdmsConfig.rdmsDataSourceName, rdmsConfig.parent.table, conn);
            DatabaseTableData childTableData = null;
            if (childProcessingEnabled) {
                childTableData = this.databaseTableDataCache.getDatabaseTableData(rdmsConfig.rdmsDataSourceName, rdmsConfig.child.table, conn);
            }
            Set<String> parentFieldsToSkip = fieldsConfig.getDbParentFieldsToSkip();
            Set<String> childFieldsToSkip = fieldsConfig.getDbChildFieldsToSkip();
            Set<String> parentTimestampFieldsInLowerCase = fieldsConfig.getParentTimestampFieldsInLowerCase();
            Set<String> childTimestampFieldsInLowerCase = fieldsConfig.getChildTimestampFieldsInLowerCase();
            for (LogData.Entry logDataEntry : logData) {
                if (logDataEntry.hasParent()) {
                    Map<String, Object> parentData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithoutFieldsToSkip(logDataEntry.parent(), parentFieldsToSkip);
                    parentData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithReplacedSysdatePlaceholders(parentData, parentTimestampFieldsInLowerCase, currentDateTime, databaseZoneId);
                    this.updateOrInsert(conn, databaseZoneId, parentTableData, preparedStatementsCache, rdmsConfig.parent.table, parentData, keysConfig.parent.getIdColumnsAsList());
                }
                if (!childProcessingEnabled || !logDataEntry.hasChilds()) continue;
                for (Map<String, Object> childData : logDataEntry.childs()) {
                    childData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithoutFieldsToSkip(childData, childFieldsToSkip);
                    childData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithReplacedSysdatePlaceholders(childData, childTimestampFieldsInLowerCase, currentDateTime, databaseZoneId);
                    this.updateOrInsert(conn, databaseZoneId, childTableData, preparedStatementsCache, rdmsConfig.child.table, childData, keysConfig.child.getIdColumnsAsList());
                }
            }
            LOG.info("Transaction is being committed");
            conn.commit();
        }
        catch (DataSourceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_LOGGING_FAILED, "Logging data failed. ${error}.", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, "Could not log to the database.", ex);
            if (conn != null) {
                try {
                    LOG.info("Transaction is being rolled back");
                    conn.rollback();
                }
                catch (SQLException e) {
                    LOG.log(Level.SEVERE, "Could not rollback the database inserts/updates", e);
                }
            }
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_LOGGING_FAILED, "Logging data failed due to database error: ${dbError}.", MapUtil.mapOf("dbError", ex.getMessage()), (Throwable)ex);
        }
        finally {
            for (PreparedStatement preparedStatement : preparedStatementsCache.values()) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Closing prepared statement failed.", ex);
                }
            }
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, "Closing database connection failed.", ex);
                }
            }
        }
        return null;
    }

    private void updateOrInsert(Connection conn, ZoneId databaseZoneId, DatabaseTableData databaseTableData, Map<String, PreparedStatement> preparedStatementsCache, String tableName, Map<String, Object> columnData, List<String> keys) throws SQLException, LogServiceException {
        LOG.fine("updateOrInsert");
        PreparedStatementBuilder preparedStatementBuilder = new PreparedStatementBuilder(conn);
        PreparedStatementData updateSqlBuilderResult = preparedStatementBuilder.createUpdateStatement(tableName, columnData, keys);
        String updateSql = updateSqlBuilderResult.getSqlStatement();
        LOG.fine(updateSql);
        PreparedStatement parentUpdateStatement = this.filledPreparedStatement(conn, databaseZoneId, databaseTableData, preparedStatementsCache, updateSqlBuilderResult.getOrderedColumnData(), updateSql);
        int updatedRows = parentUpdateStatement.executeUpdate();
        LOG.fine("updateOrInsert updatedRows: " + updatedRows);
        if (updatedRows == 0) {
            PreparedStatementData insertSqlBuilderResult = preparedStatementBuilder.createInsertStatement(tableName, columnData);
            String insertSql = insertSqlBuilderResult.getSqlStatement();
            LOG.fine(insertSql);
            PreparedStatement parentInsertStatement = this.filledPreparedStatement(conn, databaseZoneId, databaseTableData, preparedStatementsCache, insertSqlBuilderResult.getOrderedColumnData(), insertSql);
            int insertedRows = parentInsertStatement.executeUpdate();
            LOG.fine("updateOrInsert insertedRows: " + insertedRows);
        }
    }

    private PreparedStatement filledPreparedStatement(Connection conn, ZoneId databaseZoneId, DatabaseTableData databaseTableData, Map<String, PreparedStatement> preparedStatementsCache, LinkedHashMap<String, Object> columnData, String sql) throws SQLException, DateTimeParseException, LogServiceException {
        LOG.fine("filledPreparedStatement");
        PreparedStatement preparedStatement = preparedStatementsCache.get(sql);
        if (preparedStatement == null) {
            preparedStatement = conn.prepareStatement(sql);
            preparedStatementsCache.put(sql, preparedStatement);
        }
        int columnIdx = 1;
        for (Map.Entry<String, Object> entry : columnData.entrySet()) {
            int columnType;
            String columnName = entry.getKey();
            Object columnValue = entry.getValue();
            try {
                columnType = databaseTableData.getTableColumnType(columnName);
            }
            catch (NullPointerException ex) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_COLUMN_MISSING, "The column '${column}' does not exist in the database table '${table}'.", MapUtil.mapOf("table", databaseTableData.getTableNameExtractor().getTableName(), "column", columnName));
            }
            this.setValue(preparedStatement, columnIdx, columnName, columnType, columnValue, databaseZoneId);
            ++columnIdx;
        }
        return preparedStatement;
    }

    private void setValue(PreparedStatement preparedStatement, int columnIdx, String columnName, int columnType, Object columnValue, ZoneId databaseZoneId) throws SQLException, DateTimeParseException {
        LOG.fine("setValue preparedStatement=..., columnIdx=" + columnIdx + ", columnName=" + columnName + ", columnType=" + columnType + ", columnValue=..., databaseZoneId=" + databaseZoneId);
        switch (columnType) {
            case -155: 
            case -102: 
            case -101: 
            case -100: 
            case 93: {
                if (columnValue instanceof String) {
                    String columnValueAsString = (String)columnValue;
                    ZonedDateTime parsedDateTime = ZonedDateTime.parse(columnValueAsString);
                    ZonedDateTime databaseDateTime = databaseZoneId == null ? parsedDateTime : parsedDateTime.withZoneSameInstant(databaseZoneId);
                    Timestamp timestamp = Timestamp.valueOf(databaseDateTime.toLocalDateTime());
                    preparedStatement.setTimestamp(columnIdx, timestamp);
                    break;
                }
                preparedStatement.setObject(columnIdx, columnValue);
                break;
            }
            case 2004: {
                String columnValueAsString;
                if (!(columnValue instanceof String) || (columnValueAsString = (String)columnValue).length() % 4 != 0) break;
                byte[] bytes = Base64.getDecoder().decode(columnValueAsString);
                preparedStatement.setBlob(columnIdx, new ByteArrayInputStream(bytes));
                break;
            }
            default: {
                preparedStatement.setObject(columnIdx, columnValue);
            }
        }
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModule logServiceModule, LogServiceModuleInstance moduleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, String childSort, boolean addChilds) throws LogServiceException {
        LOG.info("getLogDataEntries logServiceModule=..., moduleInstance=..., timeZoneId=" + timeZoneId + ", start=" + start + ", limit=" + limit + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter + ", parentSort=" + parentSort + ", childSort=" + childSort + ", addChilds=" + addChilds);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Getting log data entries from database is not supported.");
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModuleInstance moduleInstance, String parentId) throws LogServiceException {
        LOG.info("getLogDataEntries moduleInstance=..., parentId=" + parentId);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Getting log data entries from database is not supported.");
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModuleInstance moduleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOG.info("getLogDataEntries moduleInstance=..., parentId=" + parentId + ", timeZoneId=" + timeZoneId + ", childQuery=" + childQuery + ", childFilter=" + childFilter);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Getting log data entries from database is not supported.");
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModuleInstance moduleInstance, String parentId, String childId) throws LogServiceException {
        LOG.info("getLogDataEntries moduleInstance=..., parentId=" + parentId + ", childId=" + childId);
        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_NOT_SUPPORTED, "Getting log data entries from database is not supported.");
    }
}

