/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.deeplink.Deeplink;
import de.virtimo.bpc.core.deeplink.monitor.MonitorInstanceInvestigator;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.resource.response.SimpleModuleConfigImpl;
import de.virtimo.bpc.flow.IguasuHelper;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.logservice.resource.LogDataEntries;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.TimeZoneUtil;
import de.virtimo.bpc.util.UriQueryUtil;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

public class LogServiceEndpoint {
    private static final Logger LOG = Logger.getLogger(LogServiceEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public LogServiceEndpoint(BundleContext bundleContext) {
        LOG.info("LogServiceEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private LogServiceModule getLogServiceModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (LogServiceModule)this.moduleManagerTracker.getService().getModuleById("logservice");
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    @GET
    @Path(value="/log/instances")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_CONFIG_GET_INSTANCES")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="503", description="BPC is currently in maintenance mode")})
    public Response getInstances(@Context HttpServletRequest req) {
        LOG.info("getInstances");
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            ArrayList<Map<String, Boolean>> instances = new ArrayList<Map<String, Boolean>>();
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                instances.add(Map.of("id", logServiceModuleInstance.getModuleId(), "name", logServiceModuleInstance.getConfiguration().getSettingValue("module_name").asString(""), "description", logServiceModuleInstance.getConfiguration().getSettingValue("moduleHeader_description").asString(""), "maintenanceEnabled", logServiceModuleInstance.isMaintenanceEnabled()));
            }
            return Response.ok(Map.of("instances", instances)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get list of log service instances failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/instances/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_CONFIG_GET_INSTANCE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC is currently in maintenance mode")})
    public Response getInstanceConfig(@PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOG.info("getInstanceConfig instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            return Response.ok((Object)new SimpleModuleConfigImpl(logServiceModuleInstance)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get log service instance config failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    public Response getData(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="parentQuery") String parentQuery, @QueryParam(value="parentFilter") String parentFilter, @QueryParam(value="parentSort") String parentSort, @QueryParam(value="childSort") String childSort, @QueryParam(value="addChilds") @DefaultValue(value="true") boolean addChilds, @Context HttpServletRequest req) {
        LOG.info("getData instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
            LogDataEntries logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
            return Response.ok((Object)logDataEntries).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get config or data failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/{instanceIdOrName}/{parentId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    public Response getData(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="childQuery") String childQuery, @QueryParam(value="childFilter") String childFilter, @Context HttpServletRequest req) {
        LOG.info("getData instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId);
        try {
            LogDataEntries logDataEntries;
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            if (childQuery == null && childFilter == null) {
                logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, parentId);
            } else {
                String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
            }
            return Response.ok((Object)logDataEntries).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Getting the requested log data by parentId failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/{instanceIdOrName}/{parentId}/{childId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    public Response getData(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @PathParam(value="childId") String childId, @Context HttpServletRequest req) {
        LOG.info("getData instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId + ", childId=" + childId);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            LogDataEntries logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, parentId, childId);
            return Response.ok((Object)logDataEntries).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Getting the requested log data by parentId and childId failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/log/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_WRITE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been written"), @ApiResponse(responseCode="400", description="None or invalid data to log given"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Failed to write the data"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    public Response log(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="async") @DefaultValue(value="false") boolean async, @Context HttpServletRequest req, @Context HttpHeaders hh, String json) {
        LOG.info("log (" + (async ? "asynchron" : "synchron") + ")");
        try {
            LogData logData;
            LogServicePair pair = this.getLogServicePair(req, instanceIdOrName);
            LogServiceModule logServiceModule = pair.logServiceModule;
            LogServiceModuleInstance logServiceModuleInstance = pair.logServiceModuleInstance;
            if (StringUtil.isNullOrEmpty(json)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No data to log given");
            }
            try {
                logData = JsonUtil.getInstance().convertJsonStringToPojo(json, LogData.class);
            }
            catch (IOException ex) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Could not convert the given data to a LogData object. Invalid JSON structure?", ex);
            }
            if (logData == null || logData.isEmpty()) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No JSON data to log given");
            }
            ExternalReferenceData externalReferenceData = IguasuHelper.extractIguasuSpecificHeaderValues(hh);
            logServiceModule.log(async, logServiceModuleInstance, logData, externalReferenceData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Logging failed", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}/{parentId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    public Response deleteEntry(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="childQuery") String childQuery, @QueryParam(value="childFilter") String childFilter, @Context HttpServletRequest req) {
        LOG.info("deleteEntry instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId);
        try {
            LogServicePair pair = this.getLogServicePair(req, instanceIdOrName);
            LogServiceModule logServiceModule = pair.logServiceModule;
            LogServiceModuleInstance logServiceModuleInstance = pair.logServiceModuleInstance;
            if (childQuery == null && childFilter == null) {
                List<String> parentIDs = StringUtil.explode(parentId, ",");
                logServiceModule.deleteEntries(logServiceModuleInstance, parentIDs);
            } else {
                String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                logServiceModule.deleteChildEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}/{parentId}/{childId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    public Response deleteChildEntries(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @PathParam(value="childId") String childId, @Context HttpServletRequest req) {
        LOG.info("deleteChildEntries instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId + ", childId=" + childId);
        try {
            LogServicePair pair = this.getLogServicePair(req, instanceIdOrName);
            LogServiceModule logServiceModule = pair.logServiceModule;
            LogServiceModuleInstance logServiceModuleInstance = pair.logServiceModuleInstance;
            List<String> childIDs = StringUtil.explode(childId, ",");
            logServiceModule.deleteChildEntries(logServiceModuleInstance, parentId, childIDs);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete child entries failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    public Response deleteEntries(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="parentQuery") String parentQuery, @QueryParam(value="parentFilter") String parentFilter, @Context HttpServletRequest req) {
        LOG.info("deleteEntries instanceIdOrName=" + instanceIdOrName);
        try {
            if (StringUtil.isNullOrEmpty(parentQuery) && StringUtil.isNullOrEmpty(parentFilter)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No query and no filter given.");
            }
            LogServicePair pair = this.getLogServicePair(req, instanceIdOrName);
            LogServiceModule logServiceModule = pair.logServiceModule;
            LogServiceModuleInstance logServiceModuleInstance = pair.logServiceModuleInstance;
            String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
            logServiceModule.deleteEntries(logServiceModuleInstance, timeZoneId, parentQuery, parentFilter);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}/children")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    public Response deleteChildEntries(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="childQuery") String childQuery, @QueryParam(value="childFilter") String childFilter, @Context HttpServletRequest req) {
        LOG.info("deleteChildEntries instanceIdOrName=" + instanceIdOrName);
        try {
            if (StringUtil.isNullOrEmpty(childQuery) && StringUtil.isNullOrEmpty(childFilter)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No query and no filter given.");
            }
            LogServicePair pair = this.getLogServicePair(req, instanceIdOrName);
            LogServiceModule logServiceModule = pair.logServiceModule;
            LogServiceModuleInstance logServiceModuleInstance = pair.logServiceModuleInstance;
            String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
            logServiceModule.deleteChildEntries(logServiceModuleInstance, timeZoneId, childQuery, childFilter);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete child entries failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/drop/indices/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DROP_INDICES")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Indices deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    public Response dropIndices(@PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOG.info("dropIndices instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            logServiceModule.dropIndices(logServiceModuleInstance);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Drop of parent and child indices failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private LogServicePair getLogServicePair(HttpServletRequest req, String instanceIdOrName) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException, LogServiceException {
        this.doGlobalMaintenanceModeEnabledCheck();
        LogServiceModule logServiceModule = this.getLogServiceModule();
        this.doClientCertificateAuthCheck(logServiceModule, req);
        LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
        this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
        this.doAreUsedOpenSearchIndicesAvailableCheck(logServiceModule, logServiceModuleInstance);
        return new LogServicePair(logServiceModule, logServiceModuleInstance);
    }

    private void doGlobalMaintenanceModeEnabledCheck() throws ServiceNotFoundException, LogServiceException {
        if (this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The core is currently in maintenance.");
        }
    }

    private void doClientCertificateAuthCheck(LogServiceModule logServiceModule, HttpServletRequest req) throws LogServiceException {
        boolean isClientCertificateAuthMandatory = logServiceModule.getConfiguration().getSettingValue("clientCertificateAuthMandatory").asBoolean(false);
        if (isClientCertificateAuthMandatory) {
            if (req == null) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_UNAUTHORIZED, "Not authorized");
            }
            X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length == 0) {
                LOG.info("No mutual client certificate given");
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_UNAUTHORIZED, "Not authorized (cca)");
            }
            for (X509Certificate cert : certs) {
                LOG.info("Mutual client certificate given: " + cert.getSubjectX500Principal().getName());
            }
        }
    }

    private void doModuleInstanceMaintenanceModeEnabledCheck(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (logServiceModuleInstance.isMaintenanceEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance.", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() && !logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance (OpenSearch and RDMS logging disabled).", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }

    private void doOpenSearchLoggingEnabledCheck(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance (OpenSearch logging disabled).", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }

    private void doAreUsedOpenSearchIndicesAvailableCheck(LogServiceModule logServiceModule, LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled() && logServiceModule.areUsedIndicesTemporaryUnavailable(logServiceModuleInstance)) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' uses an index that is temporary unavailable.", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }

    @GET
    @Path(value="/{instanceIdOrName}/open/logservice")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    public Response openLogServiceAdminPage(@PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOG.info("openLogServiceAdminPage instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            String redirectUrl = this.createLogServiceAdminDeeplinkUrl(logServiceModuleInstance.getModuleId());
            return Response.ok().status(Response.Status.FOUND).location(new URI(redirectUrl)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Creating the BPC deeplink and redirecting the user failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private String createLogServiceAdminDeeplinkUrl(String logServiceInstanceId) throws ModuleNotFoundException, ServiceNotFoundException {
        LOG.fine("createLogServiceAdminDeeplinkUrl logServiceInstanceId=" + logServiceInstanceId);
        return this.getCoreModule().getBpcFrontendUrl() + "?#/module/_core/_core///logservice/instanceManager/[/instance/[%22" + logServiceInstanceId + "%22]]";
    }

    @GET
    @Path(value="/{instanceIdOrName}/open/monitor")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="BPC deeplink could not be created"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    public Response openMonitorPage(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="title") String title, @QueryParam(value="promptText") String promptText, @Context HttpServletRequest req) {
        LOG.info("openMonitorPage instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            CoreModule coreModule = this.getCoreModule();
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            this.doOpenSearchLoggingEnabledCheck(logServiceModuleInstance);
            Set<String> indicesUsedByLogServiceInstance = this.getIndicesUsedByLogServiceInstance(logServiceModuleInstance);
            Set<String> monitorInstanceIDs = new MonitorInstanceInvestigator(moduleManager).getIDsOfMonitorInstancesUsingThisOpenSearchIndices(indicesUsedByLogServiceInstance);
            Map<String, String> queryParams = UriQueryUtil.getQueryParams(req.getQueryString());
            String redirectUrl = new Deeplink(coreModule.getBpcFrontendUrl()).createMonitorRedirectUrl(monitorInstanceIDs, queryParams);
            return Response.ok().status(Response.Status.FOUND).header("Location", (Object)redirectUrl).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Creating the BPC deeplink and redirecting the user failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Set<String> getIndicesUsedByLogServiceInstance(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException {
        LOG.fine("getIndicesUsedByLogServiceInstance logServiceModuleInstance=...");
        HashSet<String> indicesUsedByLogServiceInstance = new HashSet<String>();
        if (logServiceModuleInstance != null && logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            if (openSearchConfig.parent != null) {
                indicesUsedByLogServiceInstance.add(openSearchConfig.parent.index);
            }
            if (openSearchConfig.child != null) {
                indicesUsedByLogServiceInstance.add(openSearchConfig.child.index);
            }
        }
        return indicesUsedByLogServiceInstance;
    }

    private record LogServicePair(LogServiceModule logServiceModule, LogServiceModuleInstance logServiceModuleInstance) {
    }
}

