/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.RestrictedSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.CustomFieldsImpl;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class ModuleConfigurationBuilder {
    private static final Logger LOG = Logger.getLogger(ModuleConfigurationBuilder.class.getName());
    private String moduleId;
    private String instanceId;
    private String instanceType;
    private final Map<String, Setting> settingMap;

    public static ModuleConfigurationBuilder newInstance() {
        return new ModuleConfigurationBuilder();
    }

    private ModuleConfigurationBuilder() {
        this(null);
    }

    @Deprecated(since="3.3.11, 3.4.10, 3.5.4, 4.0.7, 4.1.0", forRemoval=true)
    public ModuleConfigurationBuilder(String moduleId) {
        this(moduleId, null);
    }

    @Deprecated(since="3.3.11, 3.4.10, 3.5.4, 4.0.7, 4.1.0", forRemoval=true)
    public ModuleConfigurationBuilder(String moduleId, String instanceId) {
        this(moduleId, instanceId, null);
    }

    @Deprecated(since="3.3.11, 3.4.10, 3.5.4, 4.0.7, 4.1.0", forRemoval=true)
    public ModuleConfigurationBuilder(String moduleId, String instanceId, String instanceType) {
        this.moduleId = moduleId;
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.settingMap = new HashMap<String, Setting>();
    }

    public ModuleConfigurationBuilder withModuleId(String moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public ModuleConfigurationBuilder withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public ModuleConfigurationBuilder withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public ModuleConfigurationBuilder addSetting(String key, Object value, String type) {
        this.settingMap.put(key, new SimpleSettingImpl(value, key, type, this.moduleId, this.instanceId, this.instanceType));
        return this;
    }

    public ModuleConfigurationBuilder addSetting(String key, Object value, String type, CustomFields customFields) {
        this.settingMap.put(key, new SimpleSettingImpl(value, key, type, this.moduleId, this.instanceId, this.instanceType, customFields));
        return this;
    }

    public ModuleConfigurationBuilder addSettingsFromFile(Bundle bundle, String fileName) {
        LOG.info("addSettingsFromFile bundle=" + bundle + ", fileName=" + fileName);
        Map<String, Object> loadedSettings = JsonDefaultsUtil.loadJsonFileAsMap(bundle, fileName);
        if (loadedSettings != null) {
            try {
                if (this.isSortableGroupedSettings(loadedSettings)) {
                    this.addSortableGroupedSettings(bundle, loadedSettings);
                } else if (this.isGroupedSettings(loadedSettings)) {
                    this.addGroupedSettings(bundle, loadedSettings);
                } else {
                    this.addFlatSettings(bundle, loadedSettings);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, bundle + ": Failed to add settings from file: " + fileName, ex);
            }
        }
        return this;
    }

    boolean isFlatSettings(Map<String, Object> settings) {
        if (settings != null) {
            if (settings.size() == 0) {
                return true;
            }
            for (String settingName : settings.keySet()) {
                Map settingValues;
                Object settingValuesObject = settings.get(settingName);
                if (!(settingValuesObject instanceof Map) || (settingValues = (Map)settingValuesObject).containsKey("type")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated(since="2.0.7", forRemoval=true)
    public ModuleConfigurationBuilder addFlatSettingsFromFile(Bundle bundle, String fileName) {
        LOG.info("addFlatSettingsFromFile bundle=" + bundle + ", fileName=" + fileName);
        Map<String, Object> flatSettings = JsonDefaultsUtil.loadJsonFileAsMap(bundle, fileName);
        return this.addFlatSettings(bundle, flatSettings);
    }

    @Deprecated(since="2.0.7", forRemoval=true)
    private ModuleConfigurationBuilder addFlatSettings(Bundle bundle, Map<String, Object> flatSettings) {
        LOG.info("addFlatSettings bundle=" + bundle + ", flatSettings=...");
        if (flatSettings != null) {
            for (String key : flatSettings.keySet()) {
                Map map = (Map)flatSettings.get(key);
                this.settingMap.put(key, this.createSetting(key, map, bundle));
            }
        }
        return this;
    }

    boolean isGroupedSettings(Map<String, Object> settings) {
        if (settings != null) {
            if (settings.size() == 0) {
                return true;
            }
            for (String groupName : settings.keySet()) {
                Object groupValueObject = settings.get(groupName);
                if (!(groupValueObject instanceof Map)) continue;
                Map settingsOfGroup = (Map)groupValueObject;
                for (String settingName : settingsOfGroup.keySet()) {
                    Object settingValueObject = settingsOfGroup.get(settingName);
                    if (settingValueObject instanceof Map) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Deprecated(since="3.1.2", forRemoval=true)
    public ModuleConfigurationBuilder addGroupedSettingsFromFile(Bundle bundle, String fileName) {
        LOG.info("addGroupedSettingsFromFile bundle=" + bundle + ", fileName=" + fileName);
        Map<String, Object> groupedSettings = JsonDefaultsUtil.loadJsonFileAsMap(bundle, fileName);
        return this.addGroupedSettings(bundle, groupedSettings);
    }

    @Deprecated(since="3.1.2", forRemoval=true)
    private ModuleConfigurationBuilder addGroupedSettings(Bundle bundle, Map<String, Object> groupedSettings) {
        LOG.info("addGroupedSettings bundle=" + bundle + ", groupedSettings=...");
        if (groupedSettings != null) {
            for (String group : groupedSettings.keySet()) {
                Map settingsOfGroup = (Map)groupedSettings.get(group);
                for (String key : settingsOfGroup.keySet()) {
                    Map map = (Map)settingsOfGroup.get(key);
                    map.put("_group", group);
                    this.settingMap.put(key, this.createSetting(key, map, bundle));
                }
            }
        }
        return this;
    }

    boolean isSortableGroupedSettings(Map<String, Object> settings) {
        if (settings != null) {
            if (settings.size() == 0) {
                return true;
            }
            for (String groupName : settings.keySet()) {
                Object groupValueObject = settings.get(groupName);
                if (!(groupValueObject instanceof Map)) continue;
                Map entriesOfGroup = (Map)groupValueObject;
                long groupSortPriority = MapUtil.getValueAsLong(entriesOfGroup, "sortPriority", -1L);
                List settingsOfGroup = MapUtil.getValueAsList(entriesOfGroup, "settings", null);
                if (groupSortPriority == -1L && settingsOfGroup == null) continue;
                return true;
            }
        }
        return false;
    }

    public ModuleConfigurationBuilder addSortableGroupedSettingsFromFile(Bundle bundle, String fileName) {
        LOG.info("addSortableGroupedSettingsFromFile bundle=" + bundle + ", fileName=" + fileName);
        Map<String, Object> sortableGroupedSettings = JsonDefaultsUtil.loadJsonFileAsMap(bundle, fileName);
        return this.addSortableGroupedSettings(bundle, sortableGroupedSettings);
    }

    private ModuleConfigurationBuilder addSortableGroupedSettings(Bundle bundle, Map<String, Object> sortableGroupedSettings) {
        LOG.info("addSortableGroupedSettings bundle=" + bundle + ", sortableGroupedSettings=...");
        if (sortableGroupedSettings != null) {
            for (String group : sortableGroupedSettings.keySet()) {
                Map entriesOfGroup = (Map)sortableGroupedSettings.get(group);
                long groupSortPriority = MapUtil.getValueAsLong(entriesOfGroup, "sortPriority", -1L);
                List settingsOfGroup = MapUtil.getValueAsList(entriesOfGroup, "settings", null);
                for (Map map : settingsOfGroup) {
                    map.put("_group", group);
                    if (groupSortPriority > 0L) {
                        map.put("_groupSortPriority", groupSortPriority);
                    }
                    String key = (String)map.get("name");
                    this.settingMap.put(key, this.createSetting(key, map, bundle));
                }
            }
        }
        return this;
    }

    private Setting createSetting(String key, Map<String, Object> map, Bundle bundle) {
        CustomFieldsImpl customFields;
        String type = (String)map.get("type");
        Object value = map.get("value");
        if ("json".equalsIgnoreCase(type) && value instanceof String) {
            value = ((String)value).trim().endsWith(".json") ? JsonDefaultsUtil.loadJsonFileAsListOrMap(bundle, (String)value) : JsonDefaultsUtil.parseJsonStringAsListOrMap((String)value);
        }
        if (!(customFields = new CustomFieldsImpl(map)).existsField("_writeableByRoles")) {
            customFields.setObjectValue("_writeableByRoles", RestrictedSetting.DefaultWriteableByRoles);
        }
        if (!customFields.existsField("_readableByRoles")) {
            customFields.setObjectValue("_readableByRoles", RestrictedSetting.DefaultReadableByRoles);
        }
        return new SimpleSettingImpl(value, key, type, this.moduleId, this.instanceId, this.instanceType, customFields);
    }

    public ModuleConfigurationBuilder addSettings(Collection<Setting> settings) {
        if (settings != null) {
            for (Setting setting : settings) {
                this.settingMap.put(setting.getName(), new SimpleSettingImpl(setting.getValue(), setting.getName(), setting.getType(), this.moduleId, this.instanceId, this.instanceType, new CustomFieldsImpl(setting.getCustomFields())));
            }
        }
        return this;
    }

    @Deprecated(since="3.3.11, 3.4.10, 3.5.4, 4.0.7, 4.1.0", forRemoval=true)
    public ModuleConfiguration getModuleConfiguration() {
        return this.build();
    }

    public ModuleConfiguration build() {
        return new SimpleModuleConfig(this.settingMap);
    }
}

