/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.opensearch.core.common.io.stream.BytesStreamInput;
import org.opensearch.index.mapper.RangeType;

public final class BinaryDocValuesRangeQuery
extends Query {
    private final String fieldName;
    private final QueryType queryType;
    private final RangeType.LengthType lengthType;
    private final BytesRef from;
    private final BytesRef to;
    private final Object originalFrom;
    private final Object originalTo;

    public BinaryDocValuesRangeQuery(String fieldName, QueryType queryType, RangeType.LengthType lengthType, BytesRef from, BytesRef to, Object originalFrom, Object originalTo) {
        this.fieldName = fieldName;
        this.queryType = queryType;
        this.lengthType = lengthType;
        this.from = from;
        this.to = to;
        this.originalFrom = originalFrom;
        this.originalTo = originalTo;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final BinaryDocValues values = context.reader().getBinaryDocValues(BinaryDocValuesRangeQuery.this.fieldName);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){
                    BytesStreamInput in;
                    BytesRef otherFrom;
                    BytesRef otherTo;
                    {
                        super(approximation);
                        this.in = new BytesStreamInput();
                        this.otherFrom = new BytesRef();
                        this.otherTo = new BytesRef();
                    }

                    @Override
                    public boolean matches() throws IOException {
                        byte[] bytes;
                        BytesRef encodedRanges = values.binaryValue();
                        this.in.reset(encodedRanges.bytes, encodedRanges.offset, encodedRanges.length);
                        int numRanges = this.in.readVInt();
                        this.otherFrom.bytes = bytes = encodedRanges.bytes;
                        this.otherTo.bytes = bytes;
                        int offset = this.in.getPosition();
                        for (int i = 0; i < numRanges; ++i) {
                            int length = BinaryDocValuesRangeQuery.this.lengthType.readLength(bytes, offset);
                            this.otherFrom.offset = offset;
                            this.otherFrom.length = length;
                            offset += length;
                            length = BinaryDocValuesRangeQuery.this.lengthType.readLength(bytes, offset);
                            this.otherTo.offset = offset;
                            this.otherTo.length = length;
                            offset += length;
                            if (!BinaryDocValuesRangeQuery.this.queryType.matches(BinaryDocValuesRangeQuery.this.from, BinaryDocValuesRangeQuery.this.to, this.otherFrom, this.otherTo)) continue;
                            return true;
                        }
                        assert (offset == encodedRanges.offset + encodedRanges.length);
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 4.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, BinaryDocValuesRangeQuery.this.fieldName);
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        return "BinaryDocValuesRangeQuery(fieldName=" + field + ",from=" + String.valueOf(this.originalFrom) + ",to=" + String.valueOf(this.originalTo) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryDocValuesRangeQuery that = (BinaryDocValuesRangeQuery)o;
        return Objects.equals(this.fieldName, that.fieldName) && this.queryType == that.queryType && this.lengthType == that.lengthType && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.fieldName, this.queryType, this.lengthType, this.from, this.to});
    }

    public static enum QueryType {
        INTERSECTS{

            @Override
            boolean matches(BytesRef from, BytesRef to, BytesRef otherFrom, BytesRef otherTo) {
                return from.compareTo(otherTo) <= 0 && to.compareTo(otherFrom) >= 0;
            }
        }
        ,
        WITHIN{

            @Override
            boolean matches(BytesRef from, BytesRef to, BytesRef otherFrom, BytesRef otherTo) {
                return from.compareTo(otherFrom) <= 0 && to.compareTo(otherTo) >= 0;
            }
        }
        ,
        CONTAINS{

            @Override
            boolean matches(BytesRef from, BytesRef to, BytesRef otherFrom, BytesRef otherTo) {
                return from.compareTo(otherFrom) >= 0 && to.compareTo(otherTo) <= 0;
            }
        }
        ,
        CROSSES{

            @Override
            boolean matches(BytesRef from, BytesRef to, BytesRef otherFrom, BytesRef otherTo) {
                return !(from.compareTo(otherTo) > 0 || to.compareTo(otherFrom) < 0) && !(from.compareTo(otherFrom) <= 0 && to.compareTo(otherTo) >= 0);
            }
        };


        abstract boolean matches(BytesRef var1, BytesRef var2, BytesRef var3, BytesRef var4);
    }
}

