/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenFloatKnnVectorQuery;
import org.apache.lucene.search.join.DiversifyingNearestChildrenKnnCollectorManager;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class DiversifyingChildrenByteKnnVectorQuery
extends KnnByteVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final BitSetProducer parentsFilter;
    private final Query childFilter;
    private final int k;
    private final byte[] query;

    public DiversifyingChildrenByteKnnVectorQuery(String field, byte[] query, Query childFilter, int k, BitSetProducer parentsFilter) {
        super(field, query, k, childFilter);
        this.childFilter = childFilter;
        this.parentsFilter = parentsFilter;
        this.k = k;
        this.query = query;
    }

    @Override
    protected TopDocs exactSearch(LeafReaderContext context, DocIdSetIterator acceptIterator, QueryTimeout queryTimeout) throws IOException {
        ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.field);
        if (byteVectorValues == null) {
            ByteVectorValues.checkField(context.reader(), this.field);
            return NO_RESULTS;
        }
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return NO_RESULTS;
        }
        VectorScorer scorer = byteVectorValues.scorer(this.query);
        if (scorer == null) {
            return NO_RESULTS;
        }
        DiversifyingChildrenFloatKnnVectorQuery.DiversifyingChildrenVectorScorer vectorScorer = new DiversifyingChildrenFloatKnnVectorQuery.DiversifyingChildrenVectorScorer(acceptIterator, parentBitSet, scorer);
        int queueSize = Math.min(this.k, Math.toIntExact(acceptIterator.cost()));
        HitQueue queue = new HitQueue(queueSize, true);
        TotalHits.Relation relation = TotalHits.Relation.EQUAL_TO;
        ScoreDoc topDoc = (ScoreDoc)queue.top();
        while (vectorScorer.nextParent() != Integer.MAX_VALUE) {
            if (queryTimeout != null && queryTimeout.shouldExit()) {
                relation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                break;
            }
            float score = vectorScorer.score();
            if (!(score > topDoc.score)) continue;
            topDoc.score = score;
            topDoc.doc = vectorScorer.bestChild();
            topDoc = (ScoreDoc)queue.updateTop();
        }
        while (queue.size() > 0 && ((ScoreDoc)queue.top()).score < 0.0f) {
            queue.pop();
        }
        ScoreDoc[] topScoreDocs = new ScoreDoc[queue.size()];
        for (int i = topScoreDocs.length - 1; i >= 0; --i) {
            topScoreDocs[i] = (ScoreDoc)queue.pop();
        }
        TotalHits totalHits = new TotalHits(acceptIterator.cost(), relation);
        return new TopDocs(totalHits, topScoreDocs);
    }

    @Override
    protected KnnCollectorManager getKnnCollectorManager(int k, IndexSearcher searcher) {
        return new DiversifyingNearestChildrenKnnCollectorManager(k, this.parentsFilter, searcher);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        ByteVectorValues.checkField(context.reader(), this.field);
        KnnCollector collector = knnCollectorManager.newCollector(visitedLimit, context);
        if (collector == null) {
            return NO_RESULTS;
        }
        context.reader().searchNearestVectors(this.field, this.query, collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + ":" + this.field + "[" + this.query[0] + ",...][" + this.k + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiversifyingChildrenByteKnnVectorQuery that = (DiversifyingChildrenByteKnnVectorQuery)o;
        return this.k == that.k && Objects.equals(this.parentsFilter, that.parentsFilter) && Objects.equals(this.childFilter, that.childFilter) && Arrays.equals(this.query, that.query);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.parentsFilter, this.childFilter, this.k);
        result = 31 * result + Arrays.hashCode(this.query);
        return result;
    }
}

