/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Map;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.routing.WeightedRoutingStats;
import org.opensearch.cluster.service.ClusterManagerThrottlingStats;
import org.opensearch.common.Nullable;
import org.opensearch.common.cache.service.NodeCacheStats;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.indices.breaker.AllCircuitBreakerStats;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.discovery.DiscoveryStats;
import org.opensearch.http.HttpStats;
import org.opensearch.index.SegmentReplicationRejectionStats;
import org.opensearch.index.stats.IndexingPressureStats;
import org.opensearch.index.stats.ShardIndexingPressureStats;
import org.opensearch.index.store.remote.filecache.FileCacheStats;
import org.opensearch.indices.NodeIndicesStats;
import org.opensearch.ingest.IngestStats;
import org.opensearch.monitor.fs.FsInfo;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.monitor.os.OsStats;
import org.opensearch.monitor.process.ProcessStats;
import org.opensearch.node.AdaptiveSelectionStats;
import org.opensearch.node.NodesResourceUsageStats;
import org.opensearch.node.remotestore.RemoteStoreNodeStats;
import org.opensearch.ratelimitting.admissioncontrol.stats.AdmissionControlStats;
import org.opensearch.repositories.RepositoriesStats;
import org.opensearch.script.ScriptCacheStats;
import org.opensearch.script.ScriptStats;
import org.opensearch.search.backpressure.stats.SearchBackpressureStats;
import org.opensearch.search.pipeline.SearchPipelineStats;
import org.opensearch.tasks.TaskCancellationStats;
import org.opensearch.threadpool.ThreadPoolStats;
import org.opensearch.transport.TransportStats;

public class NodeStats
extends BaseNodeResponse
implements ToXContentFragment {
    private long timestamp;
    @Nullable
    private NodeIndicesStats indices;
    @Nullable
    private OsStats os;
    @Nullable
    private ProcessStats process;
    @Nullable
    private JvmStats jvm;
    @Nullable
    private ThreadPoolStats threadPool;
    @Nullable
    private FsInfo fs;
    @Nullable
    private TransportStats transport;
    @Nullable
    private HttpStats http;
    @Nullable
    private AllCircuitBreakerStats breaker;
    @Nullable
    private ScriptStats scriptStats;
    @Nullable
    private ScriptCacheStats scriptCacheStats;
    @Nullable
    private DiscoveryStats discoveryStats;
    @Nullable
    private IngestStats ingestStats;
    @Nullable
    private AdaptiveSelectionStats adaptiveSelectionStats;
    @Nullable
    private IndexingPressureStats indexingPressureStats;
    @Nullable
    private ShardIndexingPressureStats shardIndexingPressureStats;
    @Nullable
    private SearchBackpressureStats searchBackpressureStats;
    @Nullable
    private SegmentReplicationRejectionStats segmentReplicationRejectionStats;
    @Nullable
    private ClusterManagerThrottlingStats clusterManagerThrottlingStats;
    @Nullable
    private WeightedRoutingStats weightedRoutingStats;
    @Nullable
    private FileCacheStats fileCacheStats;
    @Nullable
    private TaskCancellationStats taskCancellationStats;
    @Nullable
    private SearchPipelineStats searchPipelineStats;
    @Nullable
    private NodesResourceUsageStats resourceUsageStats;
    @Nullable
    private RepositoriesStats repositoriesStats;
    @Nullable
    private AdmissionControlStats admissionControlStats;
    @Nullable
    private NodeCacheStats nodeCacheStats;
    @Nullable
    private RemoteStoreNodeStats remoteStoreNodeStats;

    public NodeStats(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.indices = new NodeIndicesStats(in);
        }
        this.os = in.readOptionalWriteable(OsStats::new);
        this.process = in.readOptionalWriteable(ProcessStats::new);
        this.jvm = in.readOptionalWriteable(JvmStats::new);
        this.threadPool = in.readOptionalWriteable(ThreadPoolStats::new);
        this.fs = in.readOptionalWriteable(FsInfo::new);
        this.transport = in.readOptionalWriteable(TransportStats::new);
        this.http = in.readOptionalWriteable(HttpStats::new);
        this.breaker = in.readOptionalWriteable(AllCircuitBreakerStats::new);
        this.scriptStats = in.readOptionalWriteable(ScriptStats::new);
        this.discoveryStats = in.readOptionalWriteable(DiscoveryStats::new);
        this.ingestStats = in.readOptionalWriteable(IngestStats::new);
        this.adaptiveSelectionStats = in.readOptionalWriteable(AdaptiveSelectionStats::new);
        this.scriptCacheStats = null;
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
            if (in.getVersion().before(LegacyESVersion.V_7_9_0)) {
                this.scriptCacheStats = in.readOptionalWriteable(ScriptCacheStats::new);
            } else if (this.scriptStats != null) {
                this.scriptCacheStats = this.scriptStats.toScriptCacheStats();
            }
        }
        this.indexingPressureStats = in.getVersion().onOrAfter(LegacyESVersion.V_7_9_0) ? in.readOptionalWriteable(IndexingPressureStats::new) : null;
        this.shardIndexingPressureStats = in.getVersion().onOrAfter(Version.V_1_2_0) ? in.readOptionalWriteable(ShardIndexingPressureStats::new) : null;
        this.searchBackpressureStats = in.getVersion().onOrAfter(Version.V_2_4_0) ? in.readOptionalWriteable(SearchBackpressureStats::new) : null;
        this.clusterManagerThrottlingStats = in.getVersion().onOrAfter(Version.V_2_6_0) ? in.readOptionalWriteable(ClusterManagerThrottlingStats::new) : null;
        this.weightedRoutingStats = in.getVersion().onOrAfter(Version.V_2_6_0) ? in.readOptionalWriteable(WeightedRoutingStats::new) : null;
        this.fileCacheStats = in.getVersion().onOrAfter(Version.V_2_7_0) ? in.readOptionalWriteable(FileCacheStats::new) : null;
        this.taskCancellationStats = in.getVersion().onOrAfter(Version.V_2_9_0) ? in.readOptionalWriteable(TaskCancellationStats::new) : null;
        this.searchPipelineStats = in.getVersion().onOrAfter(Version.V_2_9_0) ? in.readOptionalWriteable(SearchPipelineStats::new) : null;
        this.resourceUsageStats = in.getVersion().onOrAfter(Version.V_2_12_0) ? in.readOptionalWriteable(NodesResourceUsageStats::new) : null;
        this.segmentReplicationRejectionStats = in.getVersion().onOrAfter(Version.V_2_12_0) ? in.readOptionalWriteable(SegmentReplicationRejectionStats::new) : null;
        this.repositoriesStats = in.getVersion().onOrAfter(Version.V_2_12_0) ? in.readOptionalWriteable(RepositoriesStats::new) : null;
        this.admissionControlStats = in.getVersion().onOrAfter(Version.V_2_12_0) ? in.readOptionalWriteable(AdmissionControlStats::new) : null;
        this.nodeCacheStats = in.getVersion().onOrAfter(Version.V_2_14_0) ? in.readOptionalWriteable(NodeCacheStats::new) : null;
        this.remoteStoreNodeStats = in.getVersion().onOrAfter(Version.V_2_18_0) ? in.readOptionalWriteable(RemoteStoreNodeStats::new) : null;
    }

    public NodeStats(DiscoveryNode node, long timestamp, @Nullable NodeIndicesStats indices, @Nullable OsStats os, @Nullable ProcessStats process, @Nullable JvmStats jvm, @Nullable ThreadPoolStats threadPool, @Nullable FsInfo fs, @Nullable TransportStats transport, @Nullable HttpStats http, @Nullable AllCircuitBreakerStats breaker, @Nullable ScriptStats scriptStats, @Nullable DiscoveryStats discoveryStats, @Nullable IngestStats ingestStats, @Nullable AdaptiveSelectionStats adaptiveSelectionStats, @Nullable NodesResourceUsageStats resourceUsageStats, @Nullable ScriptCacheStats scriptCacheStats, @Nullable IndexingPressureStats indexingPressureStats, @Nullable ShardIndexingPressureStats shardIndexingPressureStats, @Nullable SearchBackpressureStats searchBackpressureStats, @Nullable ClusterManagerThrottlingStats clusterManagerThrottlingStats, @Nullable WeightedRoutingStats weightedRoutingStats, @Nullable FileCacheStats fileCacheStats, @Nullable TaskCancellationStats taskCancellationStats, @Nullable SearchPipelineStats searchPipelineStats, @Nullable SegmentReplicationRejectionStats segmentReplicationRejectionStats, @Nullable RepositoriesStats repositoriesStats, @Nullable AdmissionControlStats admissionControlStats, @Nullable NodeCacheStats nodeCacheStats, @Nullable RemoteStoreNodeStats remoteStoreNodeStats) {
        super(node);
        this.timestamp = timestamp;
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.fs = fs;
        this.transport = transport;
        this.http = http;
        this.breaker = breaker;
        this.scriptStats = scriptStats;
        this.discoveryStats = discoveryStats;
        this.ingestStats = ingestStats;
        this.adaptiveSelectionStats = adaptiveSelectionStats;
        this.resourceUsageStats = resourceUsageStats;
        this.scriptCacheStats = scriptCacheStats;
        this.indexingPressureStats = indexingPressureStats;
        this.shardIndexingPressureStats = shardIndexingPressureStats;
        this.searchBackpressureStats = searchBackpressureStats;
        this.clusterManagerThrottlingStats = clusterManagerThrottlingStats;
        this.weightedRoutingStats = weightedRoutingStats;
        this.fileCacheStats = fileCacheStats;
        this.taskCancellationStats = taskCancellationStats;
        this.searchPipelineStats = searchPipelineStats;
        this.segmentReplicationRejectionStats = segmentReplicationRejectionStats;
        this.repositoriesStats = repositoriesStats;
        this.admissionControlStats = admissionControlStats;
        this.nodeCacheStats = nodeCacheStats;
        this.remoteStoreNodeStats = remoteStoreNodeStats;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    @Nullable
    public NodeIndicesStats getIndices() {
        return this.indices;
    }

    @Nullable
    public OsStats getOs() {
        return this.os;
    }

    @Nullable
    public ProcessStats getProcess() {
        return this.process;
    }

    @Nullable
    public JvmStats getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolStats getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public FsInfo getFs() {
        return this.fs;
    }

    @Nullable
    public TransportStats getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpStats getHttp() {
        return this.http;
    }

    @Nullable
    public AllCircuitBreakerStats getBreaker() {
        return this.breaker;
    }

    @Nullable
    public ScriptStats getScriptStats() {
        return this.scriptStats;
    }

    @Nullable
    public DiscoveryStats getDiscoveryStats() {
        return this.discoveryStats;
    }

    @Nullable
    public IngestStats getIngestStats() {
        return this.ingestStats;
    }

    @Nullable
    public AdaptiveSelectionStats getAdaptiveSelectionStats() {
        return this.adaptiveSelectionStats;
    }

    @Nullable
    public NodesResourceUsageStats getResourceUsageStats() {
        return this.resourceUsageStats;
    }

    @Nullable
    public ScriptCacheStats getScriptCacheStats() {
        return this.scriptCacheStats;
    }

    @Nullable
    public IndexingPressureStats getIndexingPressureStats() {
        return this.indexingPressureStats;
    }

    @Nullable
    public ShardIndexingPressureStats getShardIndexingPressureStats() {
        return this.shardIndexingPressureStats;
    }

    @Nullable
    public SearchBackpressureStats getSearchBackpressureStats() {
        return this.searchBackpressureStats;
    }

    @Nullable
    public ClusterManagerThrottlingStats getClusterManagerThrottlingStats() {
        return this.clusterManagerThrottlingStats;
    }

    public WeightedRoutingStats getWeightedRoutingStats() {
        return this.weightedRoutingStats;
    }

    public FileCacheStats getFileCacheStats() {
        return this.fileCacheStats;
    }

    @Nullable
    public TaskCancellationStats getTaskCancellationStats() {
        return this.taskCancellationStats;
    }

    @Nullable
    public SearchPipelineStats getSearchPipelineStats() {
        return this.searchPipelineStats;
    }

    @Nullable
    public SegmentReplicationRejectionStats getSegmentReplicationRejectionStats() {
        return this.segmentReplicationRejectionStats;
    }

    @Nullable
    public RepositoriesStats getRepositoriesStats() {
        return this.repositoriesStats;
    }

    @Nullable
    public AdmissionControlStats getAdmissionControlStats() {
        return this.admissionControlStats;
    }

    @Nullable
    public NodeCacheStats getNodeCacheStats() {
        return this.nodeCacheStats;
    }

    @Nullable
    public RemoteStoreNodeStats getRemoteStoreNodeStats() {
        return this.remoteStoreNodeStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        out.writeOptionalWriteable(this.os);
        out.writeOptionalWriteable(this.process);
        out.writeOptionalWriteable(this.jvm);
        out.writeOptionalWriteable(this.threadPool);
        out.writeOptionalWriteable(this.fs);
        out.writeOptionalWriteable(this.transport);
        out.writeOptionalWriteable(this.http);
        out.writeOptionalWriteable(this.breaker);
        out.writeOptionalWriteable(this.scriptStats);
        out.writeOptionalWriteable(this.discoveryStats);
        out.writeOptionalWriteable(this.ingestStats);
        out.writeOptionalWriteable(this.adaptiveSelectionStats);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_8_0) && out.getVersion().before(LegacyESVersion.V_7_9_0)) {
            out.writeOptionalWriteable(this.scriptCacheStats);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_9_0)) {
            out.writeOptionalWriteable(this.indexingPressureStats);
        }
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeOptionalWriteable(this.shardIndexingPressureStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_4_0)) {
            out.writeOptionalWriteable(this.searchBackpressureStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_6_0)) {
            out.writeOptionalWriteable(this.clusterManagerThrottlingStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_6_0)) {
            out.writeOptionalWriteable(this.weightedRoutingStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_7_0)) {
            out.writeOptionalWriteable(this.fileCacheStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_9_0)) {
            out.writeOptionalWriteable(this.taskCancellationStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_9_0)) {
            out.writeOptionalWriteable(this.searchPipelineStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_12_0)) {
            out.writeOptionalWriteable(this.resourceUsageStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_12_0)) {
            out.writeOptionalWriteable(this.segmentReplicationRejectionStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_12_0)) {
            out.writeOptionalWriteable(this.repositoriesStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_12_0)) {
            out.writeOptionalWriteable(this.admissionControlStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_14_0)) {
            out.writeOptionalWriteable(this.nodeCacheStats);
        }
        if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
            out.writeOptionalWriteable(this.remoteStoreNodeStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.getNode().getName());
        builder.field("transport_address", this.getNode().getAddress().toString());
        builder.field("host", this.getNode().getHostName());
        builder.field("ip", this.getNode().getAddress());
        builder.startArray("roles");
        for (DiscoveryNodeRole discoveryNodeRole : this.getNode().getRoles()) {
            builder.value(discoveryNodeRole.roleName());
        }
        builder.endArray();
        if (!this.getNode().getAttributes().isEmpty()) {
            builder.startObject("attributes");
            for (Map.Entry entry : this.getNode().getAttributes().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
        }
        if (this.getIndices() != null) {
            this.getIndices().toXContent(builder, params);
        }
        if (this.getOs() != null) {
            this.getOs().toXContent(builder, params);
        }
        if (this.getProcess() != null) {
            this.getProcess().toXContent(builder, params);
        }
        if (this.getJvm() != null) {
            this.getJvm().toXContent(builder, params);
        }
        if (this.getThreadPool() != null) {
            this.getThreadPool().toXContent(builder, params);
        }
        if (this.getFs() != null) {
            this.getFs().toXContent(builder, params);
        }
        if (this.getTransport() != null) {
            this.getTransport().toXContent(builder, params);
        }
        if (this.getHttp() != null) {
            this.getHttp().toXContent(builder, params);
        }
        if (this.getBreaker() != null) {
            this.getBreaker().toXContent(builder, params);
        }
        if (this.getScriptStats() != null) {
            this.getScriptStats().toXContent(builder, params);
        }
        if (this.getDiscoveryStats() != null) {
            this.getDiscoveryStats().toXContent(builder, params);
        }
        if (this.getIngestStats() != null) {
            this.getIngestStats().toXContent(builder, params);
        }
        if (this.getAdaptiveSelectionStats() != null) {
            this.getAdaptiveSelectionStats().toXContent(builder, params);
        }
        if (this.getScriptCacheStats() != null) {
            this.getScriptCacheStats().toXContent(builder, params);
        }
        if (this.getIndexingPressureStats() != null) {
            this.getIndexingPressureStats().toXContent(builder, params);
        }
        if (this.getShardIndexingPressureStats() != null) {
            this.getShardIndexingPressureStats().toXContent(builder, params);
        }
        if (this.getSearchBackpressureStats() != null) {
            this.getSearchBackpressureStats().toXContent(builder, params);
        }
        if (this.getClusterManagerThrottlingStats() != null) {
            this.getClusterManagerThrottlingStats().toXContent(builder, params);
        }
        if (this.getWeightedRoutingStats() != null) {
            this.getWeightedRoutingStats().toXContent(builder, params);
        }
        if (this.getFileCacheStats() != null) {
            this.getFileCacheStats().toXContent(builder, params);
        }
        if (this.getTaskCancellationStats() != null) {
            this.getTaskCancellationStats().toXContent(builder, params);
        }
        if (this.getSearchPipelineStats() != null) {
            this.getSearchPipelineStats().toXContent(builder, params);
        }
        if (this.getResourceUsageStats() != null) {
            this.getResourceUsageStats().toXContent(builder, params);
        }
        if (this.getSegmentReplicationRejectionStats() != null) {
            this.getSegmentReplicationRejectionStats().toXContent(builder, params);
        }
        if (this.getRepositoriesStats() != null) {
            this.getRepositoriesStats().toXContent(builder, params);
        }
        if (this.getAdmissionControlStats() != null) {
            this.getAdmissionControlStats().toXContent(builder, params);
        }
        if (this.getNodeCacheStats() != null) {
            this.getNodeCacheStats().toXContent(builder, params);
        }
        if (this.getRemoteStoreNodeStats() != null) {
            this.getRemoteStoreNodeStats().toXContent(builder, params);
        }
        return builder;
    }
}

