/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.tasks.get;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.tasks.TaskResult;

@PublicApi(since="1.0.0")
public class GetTaskResponse
extends ActionResponse
implements ToXContentObject {
    private final TaskResult task;

    public GetTaskResponse(TaskResult task) {
        this.task = Objects.requireNonNull(task, "task is required");
    }

    public GetTaskResponse(StreamInput in) throws IOException {
        super(in);
        this.task = in.readOptionalWriteable(TaskResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.task);
    }

    public TaskResult getTask() {
        return this.task;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.task.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }
}

