/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.pagination.PageToken;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class CatShardsResponse
extends ActionResponse {
    private IndicesStatsResponse indicesStatsResponse;
    private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
    private List<ShardRouting> responseShards = new ArrayList<ShardRouting>();
    private PageToken pageToken;

    public CatShardsResponse() {
    }

    public CatShardsResponse(StreamInput in) throws IOException {
        super(in);
        this.indicesStatsResponse = new IndicesStatsResponse(in);
        if (in.getVersion().onOrAfter(Version.V_2_18_0)) {
            this.nodes = DiscoveryNodes.readFrom(in, null);
            this.responseShards = in.readList(ShardRouting::new);
            if (in.readBoolean()) {
                this.pageToken = new PageToken(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.indicesStatsResponse.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
            this.nodes.writeToWithAttribute(out);
            out.writeList(this.responseShards);
            out.writeBoolean(this.pageToken != null);
            if (this.pageToken != null) {
                this.pageToken.writeTo(out);
            }
        }
    }

    public void setNodes(DiscoveryNodes nodes) {
        this.nodes = nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes;
    }

    public void setIndicesStatsResponse(IndicesStatsResponse indicesStatsResponse) {
        this.indicesStatsResponse = indicesStatsResponse;
    }

    public IndicesStatsResponse getIndicesStatsResponse() {
        return this.indicesStatsResponse;
    }

    public void setResponseShards(List<ShardRouting> responseShards) {
        this.responseShards = responseShards;
    }

    public List<ShardRouting> getResponseShards() {
        return this.responseShards;
    }

    public void setPageToken(PageToken pageToken) {
        this.pageToken = pageToken;
    }

    public PageToken getPageToken() {
        return this.pageToken;
    }
}

