/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.shards;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class IndicesShardStoresResponse
extends ActionResponse
implements ToXContentFragment {
    private final Map<String, Map<Integer, List<StoreStatus>>> storeStatuses;
    private final List<Failure> failures;

    public IndicesShardStoresResponse(Map<String, Map<Integer, List<StoreStatus>>> storeStatuses, List<Failure> failures) {
        this.storeStatuses = Collections.unmodifiableMap(storeStatuses);
        this.failures = failures;
    }

    IndicesShardStoresResponse() {
        this(Map.of(), Collections.emptyList());
    }

    public IndicesShardStoresResponse(StreamInput in) throws IOException {
        super(in);
        Map<String, Map> storeStatuses = in.readMap(StreamInput::readString, i -> i.readMap(StreamInput::readInt, j -> j.readList(StoreStatus::new)));
        this.storeStatuses = Collections.unmodifiableMap(storeStatuses);
        this.failures = Collections.unmodifiableList(in.readList(Failure::readFailure));
    }

    public Map<String, Map<Integer, List<StoreStatus>>> getStoreStatuses() {
        return this.storeStatuses;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.storeStatuses, StreamOutput::writeString, (o, v) -> o.writeMap(v, StreamOutput::writeInt, StreamOutput::writeCollection));
        out.writeList(this.failures);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failures.size() > 0) {
            builder.startArray("failures");
            for (Failure failure : this.failures) {
                failure.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.startObject("indices");
        for (Map.Entry entry : this.storeStatuses.entrySet()) {
            builder.startObject((String)entry.getKey());
            builder.startObject("shards");
            for (Map.Entry shardStatusesEntry : ((Map)entry.getValue()).entrySet()) {
                builder.startObject(String.valueOf(shardStatusesEntry.getKey()));
                builder.startArray("stores");
                for (StoreStatus storeStatus : (List)shardStatusesEntry.getValue()) {
                    builder.startObject();
                    storeStatus.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String FAILURES = "failures";
        static final String STORES = "stores";
        static final String ALLOCATION_ID = "allocation_id";
        static final String STORE_EXCEPTION = "store_exception";
        static final String ALLOCATED = "allocation";

        Fields() {
        }
    }

    @PublicApi(since="1.0.0")
    public static class Failure
    extends DefaultShardOperationFailedException {
        private String nodeId;

        public Failure(String nodeId, String index, int shardId, Throwable reason) {
            super(index, shardId, reason);
            this.nodeId = nodeId;
        }

        private Failure(StreamInput in) throws IOException {
            if (in.getVersion().before(LegacyESVersion.V_7_4_0)) {
                this.nodeId = in.readString();
            }
            Failure.readFrom(in, this);
            if (in.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
                this.nodeId = in.readString();
            }
        }

        public String nodeId() {
            return this.nodeId;
        }

        static Failure readFailure(StreamInput in) throws IOException {
            return new Failure(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().before(LegacyESVersion.V_7_4_0)) {
                out.writeString(this.nodeId);
            }
            super.writeTo(out);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
                out.writeString(this.nodeId);
            }
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("node", this.nodeId());
            return super.innerToXContent(builder, params);
        }
    }

    @PublicApi(since="1.0.0")
    public static class StoreStatus
    implements Writeable,
    ToXContentFragment,
    Comparable<StoreStatus> {
        private final DiscoveryNode node;
        private final String allocationId;
        private Exception storeException;
        private final AllocationStatus allocationStatus;

        public StoreStatus(StreamInput in) throws IOException {
            this.node = new DiscoveryNode(in);
            this.allocationId = in.readOptionalString();
            this.allocationStatus = AllocationStatus.readFrom(in);
            if (in.readBoolean()) {
                this.storeException = in.readException();
            }
        }

        public StoreStatus(DiscoveryNode node, String allocationId, AllocationStatus allocationStatus, Exception storeException) {
            this.node = node;
            this.allocationId = allocationId;
            this.allocationStatus = allocationStatus;
            this.storeException = storeException;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        public Exception getStoreException() {
            return this.storeException;
        }

        public AllocationStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            out.writeOptionalString(this.allocationId);
            this.allocationStatus.writeTo(out);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.node.toXContent(builder, params);
            if (this.allocationId != null) {
                builder.field("allocation_id", this.allocationId);
            }
            builder.field("allocation", this.allocationStatus.value());
            if (this.storeException != null) {
                builder.startObject("store_exception");
                OpenSearchException.generateThrowableXContent(builder, params, this.storeException);
                builder.endObject();
            }
            return builder;
        }

        @Override
        public int compareTo(StoreStatus other) {
            if (this.storeException != null && other.storeException == null) {
                return 1;
            }
            if (other.storeException != null && this.storeException == null) {
                return -1;
            }
            if (this.allocationId != null && other.allocationId == null) {
                return -1;
            }
            if (this.allocationId == null && other.allocationId != null) {
                return 1;
            }
            if (this.allocationId == null && other.allocationId == null) {
                return Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            }
            int compare = Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            if (compare == 0) {
                return this.allocationId.compareTo(other.allocationId);
            }
            return compare;
        }

        @PublicApi(since="1.0.0")
        public static enum AllocationStatus {
            PRIMARY(0),
            REPLICA(1),
            UNUSED(2);

            private final byte id;

            private AllocationStatus(byte id) {
                this.id = id;
            }

            private static AllocationStatus fromId(byte id) {
                switch (id) {
                    case 0: {
                        return PRIMARY;
                    }
                    case 1: {
                        return REPLICA;
                    }
                    case 2: {
                        return UNUSED;
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation status [" + id + "]");
            }

            public String value() {
                switch (this.id) {
                    case 0: {
                        return "primary";
                    }
                    case 1: {
                        return "replica";
                    }
                    case 2: {
                        return "unused";
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation status [" + this.id + "]");
            }

            private static AllocationStatus readFrom(StreamInput in) throws IOException {
                return AllocationStatus.fromId(in.readByte());
            }

            private void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.id);
            }
        }
    }
}

