/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.explain;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.opensearch.OpenSearchException;
import org.opensearch.action.RoutingMissingException;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lease.Releasables;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.index.mapper.Uid;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.search.DefaultSearchContext;
import org.opensearch.search.SearchService;
import org.opensearch.search.internal.AliasFilter;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.rescore.Rescorer;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportExplainAction
extends TransportSingleShardAction<ExplainRequest, ExplainResponse> {
    private final SearchService searchService;

    @Inject
    public TransportExplainAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/explain", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExplainRequest::new, "get");
        this.searchService = searchService;
    }

    @Override
    protected void doExecute(Task task, ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(task, request, listener);
    }

    @Override
    protected boolean resolveIndex(ExplainRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        Set<String> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(state, ((ExplainRequest)request.request()).index());
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(state, request.concreteIndex(), indicesAndAliases);
        ((ExplainRequest)request.request()).filteringAlias(aliasFilter);
        if (((ExplainRequest)request.request()).routing() == null && state.getMetadata().routingRequired(request.concreteIndex())) {
            throw new RoutingMissingException(request.concreteIndex(), ((ExplainRequest)request.request()).id());
        }
    }

    @Override
    protected void asyncShardOperation(ExplainRequest request, ShardId shardId, ActionListener<ExplainResponse> listener) throws IOException {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        indexShard.awaitShardSearchActive(b -> {
            try {
                super.asyncShardOperation(request, shardId, listener);
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        });
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, ShardId shardId) throws IOException {
        ExplainResponse explainResponse;
        Explanation explanation;
        Engine.GetResult result;
        DefaultSearchContext context;
        block8: {
            block7: {
                ShardSearchRequest shardSearchLocalRequest = new ShardSearchRequest(shardId, request.nowInMillis, request.filteringAlias());
                context = this.searchService.createSearchContext(shardSearchLocalRequest, SearchService.NO_TIMEOUT);
                result = null;
                Term uidTerm = new Term("_id", Uid.encodeId(request.id()));
                result = ((SearchContext)context).indexShard().get(new Engine.Get(false, false, request.id(), uidTerm));
                if (result.exists()) break block7;
                ExplainResponse explainResponse2 = new ExplainResponse(shardId.getIndexName(), request.id(), false);
                Releasables.close(result, context);
                return explainResponse2;
            }
            ((SearchContext)context).parsedQuery(((SearchContext)context).getQueryShardContext().toQuery(request.query()));
            ((SearchContext)context).preProcess(true);
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().docBase;
            explanation = ((SearchContext)context).searcher().explain(((SearchContext)context).query(), topLevelDocId);
            for (RescoreContext ctx : ((SearchContext)context).rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, ((SearchContext)context).searcher(), ctx, explanation);
            }
            if (request.storedFields() == null && (request.fetchSourceContext() == null || !request.fetchSourceContext().fetchSource())) break block8;
            GetResult getResult = ((SearchContext)context).indexShard().getService().get(result, request.id(), request.storedFields(), request.fetchSourceContext());
            ExplainResponse explainResponse3 = new ExplainResponse(shardId.getIndexName(), request.id(), true, explanation, getResult);
            Releasables.close(result, context);
            return explainResponse3;
        }
        try {
            explainResponse = new ExplainResponse(shardId.getIndexName(), request.id(), true, explanation);
        }
        catch (IOException e) {
            try {
                throw new OpenSearchException("Could not explain", (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Releasables.close(result, context);
                throw throwable;
            }
        }
        Releasables.close(result, context);
        return explainResponse;
    }

    @Override
    protected Writeable.Reader<ExplainResponse> getResponseReader() {
        return ExplainResponse::new;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((ExplainRequest)request.request()).id(), ((ExplainRequest)request.request()).routing(), ((ExplainRequest)request.request()).preference());
    }

    @Override
    protected String getExecutor(ExplainRequest request, ShardId shardId) {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

