/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestRequest;

@PublicApi(since="1.0.0")
public class IndicesOptions
implements ToXContentFragment {
    public static final IndicesOptions STRICT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.HIDDEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.HIDDEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED, WildcardStates.HIDDEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED, WildcardStates.HIDDEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_HIDDEN_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.HIDDEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED_IGNORE_THROTTLED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES, Option.IGNORE_THROTTLED), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.noneOf(WildcardStates.class));
    private final EnumSet<Option> options;
    private final EnumSet<WildcardStates> expandWildcards;
    private static final ParseField EXPAND_WILDCARDS_FIELD = new ParseField("expand_wildcards", new String[0]);
    private static final ParseField IGNORE_UNAVAILABLE_FIELD = new ParseField("ignore_unavailable", new String[0]);
    private static final ParseField IGNORE_THROTTLED_FIELD = new ParseField("ignore_throttled", new String[0]);
    private static final ParseField ALLOW_NO_INDICES_FIELD = new ParseField("allow_no_indices", new String[0]);

    public IndicesOptions(EnumSet<Option> options, EnumSet<WildcardStates> expandWildcards) {
        this.options = options;
        this.expandWildcards = expandWildcards;
    }

    public boolean ignoreUnavailable() {
        return this.options.contains((Object)Option.IGNORE_UNAVAILABLE);
    }

    public boolean allowNoIndices() {
        return this.options.contains((Object)Option.ALLOW_NO_INDICES);
    }

    public boolean expandWildcardsOpen() {
        return this.expandWildcards.contains((Object)WildcardStates.OPEN);
    }

    public boolean expandWildcardsClosed() {
        return this.expandWildcards.contains((Object)WildcardStates.CLOSED);
    }

    public boolean expandWildcardsHidden() {
        return this.expandWildcards.contains((Object)WildcardStates.HIDDEN);
    }

    public boolean forbidClosedIndices() {
        return this.options.contains((Object)Option.FORBID_CLOSED_INDICES);
    }

    public boolean allowAliasesToMultipleIndices() {
        return !this.options.contains((Object)Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
    }

    public boolean ignoreAliases() {
        return this.options.contains((Object)Option.IGNORE_ALIASES);
    }

    public boolean ignoreThrottled() {
        return this.options.contains((Object)Option.IGNORE_THROTTLED);
    }

    public EnumSet<WildcardStates> getExpandWildcards() {
        return EnumSet.copyOf(this.expandWildcards);
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        EnumSet<Option> options = this.options;
        out.writeEnumSet(options);
        if (out.getVersion().before(LegacyESVersion.V_7_7_0) && this.expandWildcards.contains((Object)WildcardStates.HIDDEN)) {
            EnumSet<WildcardStates> states = EnumSet.copyOf(this.expandWildcards);
            states.remove((Object)WildcardStates.HIDDEN);
            out.writeEnumSet(states);
        } else {
            out.writeEnumSet(this.expandWildcards);
        }
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        EnumSet<Option> options = in.readEnumSet(Option.class);
        EnumSet<WildcardStates> states = in.readEnumSet(WildcardStates.class);
        if (in.getVersion().before(LegacyESVersion.V_7_7_0)) {
            states.add(WildcardStates.HIDDEN);
        }
        return new IndicesOptions(options, states);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean expandToHiddenIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, expandToHiddenIndices, true, false, false, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.expandWildcardsHidden(), defaultOptions.allowAliasesToMultipleIndices(), defaultOptions.forbidClosedIndices(), defaultOptions.ignoreAliases(), defaultOptions.ignoreThrottled());
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases, boolean ignoreThrottled) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false, allowAliasesToMultipleIndices, forbidClosedIndices, ignoreAliases, ignoreThrottled);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean expandToHiddenIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases, boolean ignoreThrottled) {
        EnumSet<Option> opts = EnumSet.noneOf(Option.class);
        EnumSet<WildcardStates> wildcards = EnumSet.noneOf(WildcardStates.class);
        if (ignoreUnavailable) {
            opts.add(Option.IGNORE_UNAVAILABLE);
        }
        if (allowNoIndices) {
            opts.add(Option.ALLOW_NO_INDICES);
        }
        if (expandToOpenIndices) {
            wildcards.add(WildcardStates.OPEN);
        }
        if (expandToClosedIndices) {
            wildcards.add(WildcardStates.CLOSED);
        }
        if (expandToHiddenIndices) {
            wildcards.add(WildcardStates.HIDDEN);
        }
        if (!allowAliasesToMultipleIndices) {
            opts.add(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
        }
        if (forbidClosedIndices) {
            opts.add(Option.FORBID_CLOSED_INDICES);
        }
        if (ignoreAliases) {
            opts.add(Option.IGNORE_ALIASES);
        }
        if (ignoreThrottled) {
            opts.add(Option.IGNORE_THROTTLED);
        }
        return new IndicesOptions(opts, wildcards);
    }

    public static IndicesOptions fromRequest(RestRequest request, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(request.param("expand_wildcards"), request.param("ignore_unavailable"), request.param("allow_no_indices"), request.param("ignore_throttled"), defaultSettings);
    }

    public static IndicesOptions fromMap(Map<String, Object> map, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(map.containsKey("expand_wildcards") ? map.get("expand_wildcards") : map.get("expandWildcards"), map.containsKey("ignore_unavailable") ? map.get("ignore_unavailable") : map.get("ignoreUnavailable"), map.containsKey("allow_no_indices") ? map.get("allow_no_indices") : map.get("allowNoIndices"), map.containsKey("ignore_throttled") ? map.get("ignore_throttled") : map.get("ignoreThrottled"), defaultSettings);
    }

    public static boolean isIndicesOptions(String name) {
        return "expand_wildcards".equals(name) || "expandWildcards".equals(name) || "ignore_unavailable".equals(name) || "ignoreUnavailable".equals(name) || "ignore_throttled".equals(name) || "ignoreThrottled".equals(name) || "allow_no_indices".equals(name) || "allowNoIndices".equals(name);
    }

    public static IndicesOptions fromParameters(Object wildcardsString, Object ignoreUnavailableString, Object allowNoIndicesString, Object ignoreThrottled, IndicesOptions defaultSettings) {
        if (wildcardsString == null && ignoreUnavailableString == null && allowNoIndicesString == null && ignoreThrottled == null) {
            return defaultSettings;
        }
        EnumSet<WildcardStates> wildcards = WildcardStates.parseParameter(wildcardsString, defaultSettings.expandWildcards);
        return IndicesOptions.fromOptions(XContentMapValues.nodeBooleanValue(ignoreUnavailableString, "ignore_unavailable", defaultSettings.ignoreUnavailable()), XContentMapValues.nodeBooleanValue(allowNoIndicesString, "allow_no_indices", defaultSettings.allowNoIndices()), wildcards.contains((Object)WildcardStates.OPEN), wildcards.contains((Object)WildcardStates.CLOSED), wildcards.contains((Object)WildcardStates.HIDDEN), defaultSettings.allowAliasesToMultipleIndices(), defaultSettings.forbidClosedIndices(), defaultSettings.ignoreAliases(), XContentMapValues.nodeBooleanValue(ignoreThrottled, "ignore_throttled", defaultSettings.ignoreThrottled()));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("expand_wildcards");
        for (WildcardStates expandWildcard : this.expandWildcards) {
            builder.value(expandWildcard.toString().toLowerCase(Locale.ROOT));
        }
        builder.endArray();
        builder.field("ignore_unavailable", this.ignoreUnavailable());
        builder.field("allow_no_indices", this.allowNoIndices());
        builder.field("ignore_throttled", this.ignoreThrottled());
        return builder;
    }

    public static IndicesOptions fromXContent(XContentParser parser) throws IOException {
        EnumSet<WildcardStates> wildcardStates = null;
        Boolean allowNoIndices = null;
        Boolean ignoreUnavailable = null;
        boolean ignoreThrottled = false;
        XContentParser.Token token = parser.currentToken() == XContentParser.Token.START_OBJECT ? parser.currentToken() : parser.nextToken();
        String currentFieldName = null;
        if (token != XContentParser.Token.START_OBJECT) {
            throw new OpenSearchParseException("expected START_OBJECT as the token but was " + String.valueOf((Object)token), new Object[0]);
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (EXPAND_WILDCARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (wildcardStates == null) {
                        wildcardStates = EnumSet.noneOf(WildcardStates.class);
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token.isValue()) {
                                WildcardStates.updateSetForValue(wildcardStates, parser.text());
                                continue;
                            }
                            throw new OpenSearchParseException("expected values within array for " + EXPAND_WILDCARDS_FIELD.getPreferredName(), new Object[0]);
                        }
                        continue;
                    }
                    throw new OpenSearchParseException("already parsed expand_wildcards", new Object[0]);
                }
                throw new OpenSearchParseException(EXPAND_WILDCARDS_FIELD.getPreferredName() + " is the only field that is an array in IndicesOptions", new Object[0]);
            }
            if (token.isValue()) {
                if (EXPAND_WILDCARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (wildcardStates == null) {
                        wildcardStates = EnumSet.noneOf(WildcardStates.class);
                        WildcardStates.updateSetForValue(wildcardStates, parser.text());
                        continue;
                    }
                    throw new OpenSearchParseException("already parsed expand_wildcards", new Object[0]);
                }
                if (IGNORE_UNAVAILABLE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ignoreUnavailable = parser.booleanValue();
                    continue;
                }
                if (ALLOW_NO_INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    allowNoIndices = parser.booleanValue();
                    continue;
                }
                if (IGNORE_THROTTLED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ignoreThrottled = parser.booleanValue();
                    continue;
                }
                throw new OpenSearchParseException("could not read indices options. unexpected index option [" + currentFieldName + "]", new Object[0]);
            }
            throw new OpenSearchParseException("could not read indices options. unexpected object field [" + currentFieldName + "]", new Object[0]);
        }
        if (wildcardStates == null) {
            throw new OpenSearchParseException("indices options xcontent did not contain " + EXPAND_WILDCARDS_FIELD.getPreferredName(), new Object[0]);
        }
        if (ignoreUnavailable == null) {
            throw new OpenSearchParseException("indices options xcontent did not contain " + IGNORE_UNAVAILABLE_FIELD.getPreferredName(), new Object[0]);
        }
        if (allowNoIndices == null) {
            throw new OpenSearchParseException("indices options xcontent did not contain " + ALLOW_NO_INDICES_FIELD.getPreferredName(), new Object[0]);
        }
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, wildcardStates.contains((Object)WildcardStates.OPEN), wildcardStates.contains((Object)WildcardStates.CLOSED), wildcardStates.contains((Object)WildcardStates.HIDDEN), true, false, false, ignoreThrottled);
    }

    public static IndicesOptions strictExpandOpen() {
        return STRICT_EXPAND_OPEN;
    }

    public static IndicesOptions strictExpandOpenHidden() {
        return STRICT_EXPAND_OPEN_HIDDEN;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosed() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosedIgnoreThrottled() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED_IGNORE_THROTTLED;
    }

    public static IndicesOptions strictExpand() {
        return STRICT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions strictExpandHidden() {
        return STRICT_EXPAND_OPEN_CLOSED_HIDDEN;
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosed() {
        return STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
    }

    public static IndicesOptions lenientExpandOpen() {
        return LENIENT_EXPAND_OPEN;
    }

    public static IndicesOptions lenientExpandOpenHidden() {
        return LENIENT_EXPAND_OPEN_HIDDEN;
    }

    public static IndicesOptions lenientExpand() {
        return LENIENT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions lenientExpandHidden() {
        return LENIENT_EXPAND_OPEN_CLOSED_HIDDEN;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndicesOptions other = (IndicesOptions)obj;
        return this.options.equals(other.options) && this.expandWildcards.equals(other.expandWildcards);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        return 31 * result + this.expandWildcards.hashCode();
    }

    public String toString() {
        return "IndicesOptions[ignore_unavailable=" + this.ignoreUnavailable() + ", allow_no_indices=" + this.allowNoIndices() + ", expand_wildcards_open=" + this.expandWildcardsOpen() + ", expand_wildcards_closed=" + this.expandWildcardsClosed() + ", expand_wildcards_hidden=" + this.expandWildcardsHidden() + ", allow_aliases_to_multiple_indices=" + this.allowAliasesToMultipleIndices() + ", forbid_closed_indices=" + this.forbidClosedIndices() + ", ignore_aliases=" + this.ignoreAliases() + ", ignore_throttled=" + this.ignoreThrottled() + "]";
    }

    public static enum Option {
        IGNORE_UNAVAILABLE,
        IGNORE_ALIASES,
        ALLOW_NO_INDICES,
        FORBID_ALIASES_TO_MULTIPLE_INDICES,
        FORBID_CLOSED_INDICES,
        IGNORE_THROTTLED;

        public static final EnumSet<Option> NONE;

        static {
            NONE = EnumSet.noneOf(Option.class);
        }
    }

    @PublicApi(since="1.0.0")
    public static enum WildcardStates {
        OPEN,
        CLOSED,
        HIDDEN;

        public static final EnumSet<WildcardStates> NONE;

        public static EnumSet<WildcardStates> parseParameter(Object value, EnumSet<WildcardStates> defaultStates) {
            String[] wildcards;
            if (value == null) {
                return defaultStates;
            }
            EnumSet<WildcardStates> states = EnumSet.noneOf(WildcardStates.class);
            for (String wildcard : wildcards = XContentMapValues.nodeStringArrayValue(value)) {
                WildcardStates.updateSetForValue(states, wildcard);
            }
            return states;
        }

        public static XContentBuilder toXContent(EnumSet<WildcardStates> states, XContentBuilder builder) throws IOException {
            if (states.isEmpty()) {
                builder.field("expand_wildcards", "none");
            } else if (states.containsAll(EnumSet.allOf(WildcardStates.class))) {
                builder.field("expand_wildcards", "all");
            } else {
                builder.field("expand_wildcards", states.stream().map(state -> state.toString().toLowerCase(Locale.ROOT)).collect(Collectors.joining(",")));
            }
            return builder;
        }

        private static void updateSetForValue(EnumSet<WildcardStates> states, String wildcard) {
            switch (wildcard) {
                case "open": {
                    states.add(OPEN);
                    break;
                }
                case "closed": {
                    states.add(CLOSED);
                    break;
                }
                case "hidden": {
                    states.add(HIDDEN);
                    break;
                }
                case "none": {
                    states.clear();
                    break;
                }
                case "all": {
                    states.addAll(EnumSet.allOf(WildcardStates.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
                }
            }
        }

        static {
            NONE = EnumSet.noneOf(WildcardStates.class);
        }
    }
}

