/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.tasks.TaskCancelledException;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskAwareRequest;
import org.opensearch.tasks.TaskListener;
import org.opensearch.tasks.TaskManager;
import org.opensearch.transport.TransportRequest;

@PublicApi(since="1.0.0")
public abstract class TransportAction<Request extends ActionRequest, Response extends ActionResponse> {
    public final String actionName;
    private final ActionFilter[] filters;
    protected final TaskManager taskManager;
    @Deprecated
    protected Logger logger = LogManager.getLogger(this.getClass());

    protected TransportAction(String actionName, ActionFilters actionFilters, TaskManager taskManager) {
        this.actionName = actionName;
        this.filters = actionFilters.filters();
        this.taskManager = taskManager;
    }

    private Releasable registerChildNode(TaskId parentTask) {
        if (parentTask.isSet()) {
            return this.taskManager.registerChildNode(parentTask.getId(), this.taskManager.localNode());
        }
        return () -> {};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task execute(Request request, final ActionListener<Response> listener) {
        Task task;
        final Releasable unregisterChildNode = this.registerChildNode(((TransportRequest)request).getParentTask());
        try {
            task = this.taskManager.register("transport", this.actionName, (TaskAwareRequest)request);
        }
        catch (TaskCancelledException e) {
            unregisterChildNode.close();
            throw e;
        }
        try (ThreadContext.StoredContext storedContext = this.taskManager.taskExecutionStarted(task);){
            this.execute(task, request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        Releasables.close(unregisterChildNode, () -> TransportAction.this.taskManager.unregister(task));
                    }
                    finally {
                        listener.onResponse(response);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        Releasables.close(unregisterChildNode, () -> TransportAction.this.taskManager.unregister(task));
                    }
                    finally {
                        listener.onFailure(e);
                    }
                }
            });
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task execute(Request request, final TaskListener<Response> listener) {
        Task task;
        final Releasable unregisterChildNode = this.registerChildNode(((TransportRequest)request).getParentTask());
        try {
            task = this.taskManager.register("transport", this.actionName, (TaskAwareRequest)request);
        }
        catch (TaskCancelledException e) {
            unregisterChildNode.close();
            throw e;
        }
        try (ThreadContext.StoredContext storedContext = this.taskManager.taskExecutionStarted(task);){
            this.execute(task, request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        Releasables.close(unregisterChildNode, () -> TransportAction.this.taskManager.unregister(task));
                    }
                    finally {
                        listener.onResponse(task, response);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        Releasables.close(unregisterChildNode, () -> TransportAction.this.taskManager.unregister(task));
                    }
                    finally {
                        listener.onFailure(task, e);
                    }
                }
            });
        }
        return task;
    }

    public final void execute(Task task, Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException = ((ActionRequest)request).validate();
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        if (task != null && ((ActionRequest)request).getShouldStoreResult()) {
            listener = new TaskResultStoringActionListener<Response>(this.taskManager, task, listener);
        }
        RequestFilterChain<Request, Response> requestFilterChain = new RequestFilterChain<Request, Response>(this, this.logger);
        requestFilterChain.proceed(task, this.actionName, request, listener);
    }

    protected abstract void doExecute(Task var1, Request var2, ActionListener<Response> var3);

    private static class TaskResultStoringActionListener<Response extends ActionResponse>
    implements ActionListener<Response> {
        private final ActionListener<Response> delegate;
        private final Task task;
        private final TaskManager taskManager;

        private TaskResultStoringActionListener(TaskManager taskManager, Task task, ActionListener<Response> delegate) {
            this.taskManager = taskManager;
            this.task = task;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(Response response) {
            try {
                this.taskManager.storeResult(this.task, response, this.delegate);
            }
            catch (Exception e) {
                this.delegate.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.taskManager.storeResult(this.task, e, this.delegate);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.delegate.onFailure(inner);
            }
        }
    }

    private static class RequestFilterChain<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain<Request, Response> {
        private final TransportAction<Request, Response> action;
        private final AtomicInteger index = new AtomicInteger();
        private final Logger logger;

        private RequestFilterChain(TransportAction<Request, Response> action, Logger logger) {
            this.action = action;
            this.logger = logger;
        }

        @Override
        public void proceed(Task task, String actionName, Request request, ActionListener<Response> listener) {
            int i = this.index.getAndIncrement();
            try {
                if (i < this.action.filters.length) {
                    this.action.filters[i].apply(task, actionName, request, listener, this);
                } else if (i == this.action.filters.length) {
                    this.action.doExecute(task, request, listener);
                } else {
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
            }
            catch (Exception e) {
                this.logger.trace("Error during transport action execution.", (Throwable)e);
                listener.onFailure(e);
            }
        }
    }
}

