/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.slm;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class SnapshotRetentionConfiguration
implements ToXContentObject {
    public static final SnapshotRetentionConfiguration EMPTY = new SnapshotRetentionConfiguration(null, null, null);
    private static final ParseField EXPIRE_AFTER = new ParseField("expire_after", new String[0]);
    private static final ParseField MINIMUM_SNAPSHOT_COUNT = new ParseField("min_count", new String[0]);
    private static final ParseField MAXIMUM_SNAPSHOT_COUNT = new ParseField("max_count", new String[0]);
    private static final ConstructingObjectParser<SnapshotRetentionConfiguration, Void> PARSER = new ConstructingObjectParser("snapshot_retention", true, a -> {
        TimeValue expireAfter = a[0] == null ? null : TimeValue.parseTimeValue((String)a[0], EXPIRE_AFTER.getPreferredName());
        Integer minCount = (Integer)a[1];
        Integer maxCount = (Integer)a[2];
        return new SnapshotRetentionConfiguration(expireAfter, minCount, maxCount);
    });
    private final TimeValue expireAfter;
    private final Integer minimumSnapshotCount;
    private final Integer maximumSnapshotCount;

    public SnapshotRetentionConfiguration(@Nullable TimeValue expireAfter, @Nullable Integer minimumSnapshotCount, @Nullable Integer maximumSnapshotCount) {
        this.expireAfter = expireAfter;
        this.minimumSnapshotCount = minimumSnapshotCount;
        this.maximumSnapshotCount = maximumSnapshotCount;
        if (this.minimumSnapshotCount != null && this.minimumSnapshotCount < 1) {
            throw new IllegalArgumentException("minimum snapshot count must be at least 1, but was: " + this.minimumSnapshotCount);
        }
        if (this.maximumSnapshotCount != null && this.maximumSnapshotCount < 1) {
            throw new IllegalArgumentException("maximum snapshot count must be at least 1, but was: " + this.maximumSnapshotCount);
        }
        if (maximumSnapshotCount != null && minimumSnapshotCount != null && this.minimumSnapshotCount > this.maximumSnapshotCount) {
            throw new IllegalArgumentException("minimum snapshot count " + this.minimumSnapshotCount + " cannot be larger than maximum snapshot count " + this.maximumSnapshotCount);
        }
    }

    public static SnapshotRetentionConfiguration parse(XContentParser parser, String name) {
        return PARSER.apply(parser, null);
    }

    public TimeValue getExpireAfter() {
        return this.expireAfter;
    }

    public Integer getMinimumSnapshotCount() {
        return this.minimumSnapshotCount;
    }

    public Integer getMaximumSnapshotCount() {
        return this.maximumSnapshotCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.expireAfter != null) {
            builder.field(EXPIRE_AFTER.getPreferredName(), this.expireAfter.getStringRep());
        }
        if (this.minimumSnapshotCount != null) {
            builder.field(MINIMUM_SNAPSHOT_COUNT.getPreferredName(), this.minimumSnapshotCount);
        }
        if (this.maximumSnapshotCount != null) {
            builder.field(MAXIMUM_SNAPSHOT_COUNT.getPreferredName(), this.maximumSnapshotCount);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.expireAfter, this.minimumSnapshotCount, this.maximumSnapshotCount);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotRetentionConfiguration other = (SnapshotRetentionConfiguration)obj;
        return Objects.equals(this.expireAfter, other.expireAfter) && Objects.equals(this.minimumSnapshotCount, other.minimumSnapshotCount) && Objects.equals(this.maximumSnapshotCount, other.maximumSnapshotCount);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), EXPIRE_AFTER);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MINIMUM_SNAPSHOT_COUNT);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAXIMUM_SNAPSHOT_COUNT);
    }
}

