/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ClusterStateTermVersion
implements Writeable {
    private final ClusterName clusterName;
    private final String clusterUUID;
    private final long term;
    private final long version;

    public ClusterStateTermVersion(ClusterName clusterName, String clusterUUID, long term, long version) {
        this.clusterName = clusterName;
        this.clusterUUID = clusterUUID;
        this.term = term;
        this.version = version;
    }

    public ClusterStateTermVersion(StreamInput in) throws IOException {
        this.clusterName = new ClusterName(in);
        this.clusterUUID = in.readString();
        this.term = in.readLong();
        this.version = in.readLong();
    }

    public ClusterStateTermVersion(ClusterState state) {
        this.clusterName = state.getClusterName();
        this.clusterUUID = state.metadata().clusterUUID();
        this.term = state.term();
        this.version = state.version();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeString(this.clusterUUID);
        out.writeLong(this.term);
        out.writeLong(this.version);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getTerm() {
        return this.term;
    }

    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return "ClusterStateTermVersion{clusterName=" + String.valueOf(this.clusterName) + ", clusterUUID='" + this.clusterUUID + "', term=" + this.term + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateTermVersion that = (ClusterStateTermVersion)o;
        if (this.term != that.term) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (!this.clusterName.equals(that.clusterName)) {
            return false;
        }
        return this.clusterUUID.equals(that.clusterUUID);
    }

    public int hashCode() {
        int result = this.clusterName.hashCode();
        result = 31 * result + this.clusterUUID.hashCode();
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }
}

