/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.List;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String NAME = "same_shard";
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING = Setting.boolSetting("cluster.routing.allocation.same_shard.host", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean sameHost;

    public SameShardAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.sameHost = CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING, this::setSameHost);
    }

    private void setSameHost(boolean sameHost) {
        this.sameHost = sameHost;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        Decision decision = this.decideSameNode(shardRouting, node, allocation, assignedShards);
        if (decision.type() == Decision.Type.NO || !this.sameHost) {
            return decision;
        }
        if (node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null) continue;
                boolean checkNodeOnSameHostName = false;
                boolean checkNodeOnSameHostAddress = false;
                if (Strings.hasLength(checkNode.node().getHostAddress()) && Strings.hasLength(node.node().getHostAddress())) {
                    if (checkNode.node().getHostAddress().equals(node.node().getHostAddress())) {
                        checkNodeOnSameHostAddress = true;
                    }
                } else if (Strings.hasLength(checkNode.node().getHostName()) && Strings.hasLength(node.node().getHostName()) && checkNode.node().getHostName().equals(node.node().getHostName())) {
                    checkNodeOnSameHostName = true;
                }
                if (!checkNodeOnSameHostAddress && !checkNodeOnSameHostName) continue;
                for (ShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    String hostType = checkNodeOnSameHostAddress ? "address" : "name";
                    String host = checkNodeOnSameHostAddress ? node.node().getHostAddress() : node.node().getHostName();
                    return allocation.decision(Decision.NO, NAME, "a copy of this shard is already allocated to host %s [%s], on node [%s], and [%s] is [true] which forbids more than one node on this host from holding a copy of this shard", hostType, host, node.nodeId(), CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.getKey());
                }
            }
        }
        return allocation.decision(Decision.YES, NAME, "none of the nodes on this host hold a copy of this shard", new Object[0]);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call force allocate on a non-primary shard";
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        return this.decideSameNode(shardRouting, node, allocation, assignedShards);
    }

    private Decision decideSameNode(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, Iterable<ShardRouting> assignedShards) {
        for (ShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            if (assignedShard.isSameAllocation(shardRouting)) {
                return allocation.decision(Decision.NO, NAME, "this shard is already allocated to this node [%s]", shardRouting.toString());
            }
            return allocation.decision(Decision.NO, NAME, "a copy of this shard is already allocated to this node [%s]", assignedShard.toString());
        }
        return allocation.decision(Decision.YES, NAME, "this node does not hold a copy of this shard", new Object[0]);
    }
}

