/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.io.stream;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public abstract class DelayableWriteable<T extends Writeable>
implements Writeable {
    public static <T extends Writeable> DelayableWriteable<T> referencing(T reference) {
        return new Referencing<T>(reference);
    }

    public static <T extends Writeable> DelayableWriteable<T> delayed(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        return new Serialized<T>(reader, in.getVersion(), in.namedWriteableRegistry(), in.readBytesReference());
    }

    private DelayableWriteable() {
    }

    public abstract Serialized<T> asSerialized(Writeable.Reader<T> var1, NamedWriteableRegistry var2);

    public abstract T expand();

    abstract boolean isSerialized();

    private static class Referencing<T extends Writeable>
    extends DelayableWriteable<T> {
        private final T reference;

        private Referencing(T reference) {
            this.reference = reference;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.writeToBuffer(out.getVersion()).bytes());
        }

        @Override
        public T expand() {
            return this.reference;
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            BytesStreamOutput buffer;
            try {
                buffer = this.writeToBuffer(Version.CURRENT);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error writing writeable to buffer", e);
            }
            return new Serialized<T>(reader, Version.CURRENT, registry, buffer.bytes());
        }

        @Override
        boolean isSerialized() {
            return false;
        }

        private BytesStreamOutput writeToBuffer(Version version) throws IOException {
            try (BytesStreamOutput buffer = new BytesStreamOutput();){
                buffer.setVersion(version);
                this.reference.writeTo(buffer);
                BytesStreamOutput bytesStreamOutput = buffer;
                return bytesStreamOutput;
            }
        }
    }

    @PublicApi(since="1.0.0")
    public static class Serialized<T extends Writeable>
    extends DelayableWriteable<T>
    implements Accountable {
        private final Writeable.Reader<T> reader;
        private final Version serializedAtVersion;
        private final NamedWriteableRegistry registry;
        private final BytesReference serialized;

        private Serialized(Writeable.Reader<T> reader, Version serializedAtVersion, NamedWriteableRegistry registry, BytesReference serialized) {
            this.reader = reader;
            this.serializedAtVersion = serializedAtVersion;
            this.registry = registry;
            this.serialized = serialized;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion() == this.serializedAtVersion) {
                out.writeBytesReference(this.serialized);
            } else {
                Serialized.referencing(this.expand()).writeTo(out);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T expand() {
            try (StreamInput in = this.registry == null ? this.serialized.streamInput() : new NamedWriteableAwareStreamInput(this.serialized.streamInput(), this.registry);){
                in.setVersion(this.serializedAtVersion);
                Writeable writeable = (Writeable)this.reader.read(in);
                return (T)writeable;
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error expanding serialized delayed writeable", e);
            }
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            return this;
        }

        @Override
        boolean isSerialized() {
            return true;
        }

        @Override
        public long ramBytesUsed() {
            return this.serialized.ramBytesUsed() + (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF * 3) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
    }
}

