/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.opensearch.common.SetOnce;

@Plugin(category="Converter", name="NodeAndClusterIdConverter")
@ConverterKeys(value={"node_and_cluster_id"})
public final class NodeAndClusterIdConverter
extends LogEventPatternConverter {
    private static final SetOnce<String> nodeAndClusterId = new SetOnce();

    public static NodeAndClusterIdConverter newInstance(String[] options) {
        return new NodeAndClusterIdConverter();
    }

    public NodeAndClusterIdConverter() {
        super("NodeAndClusterId", "node_and_cluster_id");
    }

    public static void setNodeIdAndClusterId(String nodeId, String clusterUUID) {
        nodeAndClusterId.set(NodeAndClusterIdConverter.formatIds(clusterUUID, nodeId));
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (nodeAndClusterId.get() != null) {
            toAppendTo.append(nodeAndClusterId.get());
        }
    }

    private static String formatIds(String clusterUUID, String nodeId) {
        return String.format(Locale.ROOT, "\"cluster.uuid\": \"%s\", \"node.id\": \"%s\"", clusterUUID, nodeId);
    }
}

