/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.ExponentiallyWeightedMovingAverage;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ResizableBlockingQueue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.TimedRunnable;
import org.opensearch.common.util.concurrent.WrappedRunnable;
import org.opensearch.common.util.concurrent.XRejectedExecutionHandler;

public final class QueueResizingOpenSearchThreadPoolExecutor
extends OpenSearchThreadPoolExecutor {
    public static double EWMA_ALPHA = 0.3;
    private static final Logger logger = LogManager.getLogger(QueueResizingOpenSearchThreadPoolExecutor.class);
    private static final int QUEUE_ADJUSTMENT_AMOUNT = 50;
    private final Function<Runnable, WrappedRunnable> runnableWrapper;
    private final ResizableBlockingQueue<Runnable> workQueue;
    private final int tasksPerFrame;
    private final int minQueueSize;
    private final int maxQueueSize;
    private final long targetedResponseTimeNanos;
    private final ExponentiallyWeightedMovingAverage executionEWMA;
    private final CounterMetric poolWaitTime;
    private final AtomicLong totalTaskNanos = new AtomicLong(0L);
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private long startNs;

    QueueResizingOpenSearchThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ResizableBlockingQueue<Runnable> workQueue, int minQueueSize, int maxQueueSize, Function<Runnable, WrappedRunnable> runnableWrapper, int tasksPerFrame, TimeValue targetedResponseTime, ThreadFactory threadFactory, XRejectedExecutionHandler handler, ThreadContext contextHolder) {
        super(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, contextHolder);
        this.runnableWrapper = runnableWrapper;
        this.workQueue = workQueue;
        this.tasksPerFrame = tasksPerFrame;
        this.startNs = System.nanoTime();
        this.minQueueSize = minQueueSize;
        this.maxQueueSize = maxQueueSize;
        this.targetedResponseTimeNanos = targetedResponseTime.getNanos();
        this.executionEWMA = new ExponentiallyWeightedMovingAverage(EWMA_ALPHA, 0.0);
        this.poolWaitTime = new CounterMetric();
        logger.debug("thread pool [{}] will adjust queue by [{}] when determining automatic queue size", (Object)this.getName(), (Object)50);
    }

    @Override
    protected Runnable wrapRunnable(Runnable command) {
        return super.wrapRunnable(this.runnableWrapper.apply(command));
    }

    @Override
    protected Runnable unwrap(Runnable runnable) {
        Runnable unwrapped = super.unwrap(runnable);
        if (unwrapped instanceof WrappedRunnable) {
            return ((WrappedRunnable)unwrapped).unwrap();
        }
        return unwrapped;
    }

    static double calculateLambda(int totalNumberOfTasks, long totalFrameTaskNanos) {
        assert (totalFrameTaskNanos > 0L) : "cannot calculate for instantaneous tasks, got: " + totalFrameTaskNanos;
        assert (totalNumberOfTasks > 0) : "cannot calculate for no tasks, got: " + totalNumberOfTasks;
        return (double)totalNumberOfTasks / (double)totalFrameTaskNanos;
    }

    static int calculateL(double lambda, long targetedResponseTimeNanos) {
        assert (targetedResponseTimeNanos > 0L) : "cannot calculate for instantaneous requests";
        return Math.toIntExact((long)(lambda * (double)targetedResponseTimeNanos));
    }

    public double getTaskExecutionEWMA() {
        return this.executionEWMA.getAverage();
    }

    public int getCurrentQueueSize() {
        return this.workQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        assert (super.unwrap(r) instanceof TimedRunnable) : "expected only TimedRunnables in queue";
        TimedRunnable timedRunnable = (TimedRunnable)super.unwrap(r);
        long taskNanos = timedRunnable.getTotalNanos();
        boolean failedOrRejected = timedRunnable.getFailedOrRejected();
        long totalNanos = this.totalTaskNanos.addAndGet(taskNanos);
        long taskExecutionNanos = timedRunnable.getTotalExecutionNanos();
        assert (taskExecutionNanos >= 0L || failedOrRejected && taskExecutionNanos == -1L) : "expected task to always take longer than 0 nanoseconds or have '-1' failure code, got: " + taskExecutionNanos + ", failedOrRejected: " + failedOrRejected;
        if (taskExecutionNanos != -1L) {
            this.executionEWMA.addValue(taskExecutionNanos);
        }
        this.poolWaitTime.inc(timedRunnable.getWaitTimeNanos());
        if (this.taskCount.incrementAndGet() == this.tasksPerFrame) {
            long endTimeNs = System.nanoTime();
            long totalRuntime = endTimeNs - this.startNs;
            this.startNs = endTimeNs;
            try {
                int newCapacity;
                double lambda = QueueResizingOpenSearchThreadPoolExecutor.calculateLambda(this.tasksPerFrame, Math.max(totalNanos, 1L));
                int desiredQueueSize = QueueResizingOpenSearchThreadPoolExecutor.calculateL(lambda, this.targetedResponseTimeNanos);
                int oldCapacity = this.workQueue.capacity();
                if (logger.isDebugEnabled()) {
                    long avgTaskTime = totalNanos / (long)this.tasksPerFrame;
                    logger.debug("[{}]: there were [{}] tasks in [{}], avg task time [{}], EWMA task execution [{}], [{} tasks/s], optimal queue is [{}], current capacity [{}]", (Object)this.getName(), (Object)this.tasksPerFrame, (Object)TimeValue.timeValueNanos(totalRuntime), (Object)TimeValue.timeValueNanos(avgTaskTime), (Object)TimeValue.timeValueNanos((long)this.executionEWMA.getAverage()), (Object)String.format(Locale.ROOT, "%.2f", lambda * (double)TimeValue.timeValueSeconds(1L).nanos()), (Object)desiredQueueSize, (Object)oldCapacity);
                }
                if (oldCapacity != (newCapacity = this.workQueue.adjustCapacity(desiredQueueSize, 50, this.minQueueSize, this.maxQueueSize)) && logger.isDebugEnabled()) {
                    logger.debug("adjusted [{}] queue size by [{}], old capacity: [{}], new capacity: [{}]", (Object)this.getName(), (Object)(newCapacity > oldCapacity ? 50 : -50), (Object)oldCapacity, (Object)newCapacity);
                }
            }
            catch (ArithmeticException e) {
                logger.warn(() -> new ParameterizedMessage("failed to calculate optimal queue size for [{}] thread pool, total frame time [{}ns], tasks [{}], task execution time [{}ns]", new Object[]{this.getName(), totalRuntime, this.tasksPerFrame, totalNanos}), (Throwable)e);
            }
            finally {
                int tasks = this.taskCount.addAndGet(-this.tasksPerFrame);
                assert (tasks >= 0) : "tasks should never be negative, got: " + tasks;
                if (tasks >= this.tasksPerFrame) {
                    logger.debug("[{}]: too many incoming tasks while queue size adjustment occurs, resetting measurements to 0", (Object)this.getName());
                    this.totalTaskNanos.getAndSet(1L);
                    this.taskCount.getAndSet(0);
                    this.startNs = System.nanoTime();
                } else {
                    this.totalTaskNanos.addAndGet(-totalNanos);
                }
            }
        }
    }

    @Override
    protected void appendThreadPoolExecutorDetails(StringBuilder sb) {
        sb.append("min queue capacity = ").append(this.minQueueSize).append(", ");
        sb.append("max queue capacity = ").append(this.maxQueueSize).append(", ");
        sb.append("frame size = ").append(this.tasksPerFrame).append(", ");
        sb.append("targeted response rate = ").append(TimeValue.timeValueNanos(this.targetedResponseTimeNanos)).append(", ");
        sb.append("task execution EWMA = ").append(TimeValue.timeValueNanos((long)this.executionEWMA.getAverage())).append(", ");
        sb.append("adjustment amount = ").append(50).append(", ");
    }

    @Override
    public long getPoolWaitTimeNanos() {
        return this.poolWaitTime.count();
    }
}

