/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;

public class RemoteCoordinationMetadata
extends AbstractClusterMetadataWriteableBlobEntity<CoordinationMetadata> {
    public static final String COORDINATION_METADATA = "coordination";
    public static final ChecksumBlobStoreFormat<CoordinationMetadata> COORDINATION_METADATA_FORMAT = new ChecksumBlobStoreFormat<CoordinationMetadata>("coordination", "%s", CoordinationMetadata::fromXContent);
    private CoordinationMetadata coordinationMetadata;
    private long metadataVersion;

    public RemoteCoordinationMetadata(CoordinationMetadata coordinationMetadata, long metadataVersion, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.coordinationMetadata = coordinationMetadata;
        this.metadataVersion = metadataVersion;
    }

    public RemoteCoordinationMetadata(String blobName, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("global-metadata"), COORDINATION_METADATA);
    }

    @Override
    public String getType() {
        return COORDINATION_METADATA;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.metadataVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public InputStream serialize() throws IOException {
        return COORDINATION_METADATA_FORMAT.serialize(this.coordinationMetadata, this.generateBlobFileName(), this.getCompressor(), RemoteClusterStateUtils.FORMAT_PARAMS).streamInput();
    }

    @Override
    public CoordinationMetadata deserialize(InputStream inputStream) throws IOException {
        return COORDINATION_METADATA_FORMAT.deserialize(this.blobName, this.getNamedXContentRegistry(), Streams.readFully(inputStream));
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(COORDINATION_METADATA, this.blobName);
    }
}

