/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.fuzzy;

import java.io.IOException;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.OpenSearchException;
import org.opensearch.common.util.LongArray;

class IndexInputImmutableLongArray
implements LongArray {
    private final RandomAccessInput input;
    private final long size;

    IndexInputImmutableLongArray(long size, RandomAccessInput input) {
        this.size = size;
        this.input = input;
    }

    @Override
    public void close() {
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public synchronized long get(long index) {
        try {
            return this.input.readLong(index << 3);
        }
        catch (IOException ex) {
            throw new OpenSearchException(ex);
        }
    }

    @Override
    public long set(long index, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long increment(long index, long inc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(long fromIndex, long toIndex, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.shallowSizeOfInstance(IndexInputImmutableLongArray.class);
    }
}

