/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.compositeindex.datacube.MetricStat;

@ExperimentalApi
public class Metric
implements ToXContent {
    private final String field;
    private final List<MetricStat> metrics;
    private final List<MetricStat> baseMetrics;

    public Metric(String field, List<MetricStat> metrics) {
        this.field = field;
        this.metrics = metrics;
        this.baseMetrics = new ArrayList<MetricStat>();
        for (MetricStat metricStat : metrics) {
            if (metricStat.isDerivedMetric()) continue;
            this.baseMetrics.add(metricStat);
        }
    }

    public String getField() {
        return this.field;
    }

    public List<MetricStat> getMetrics() {
        return this.metrics;
    }

    public List<MetricStat> getBaseMetrics() {
        return this.baseMetrics;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.field);
        builder.startArray("stats");
        for (MetricStat metricType : this.metrics) {
            builder.value(metricType.getTypeName());
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.field, metric.field) && Objects.equals(this.metrics, metric.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.metrics);
    }
}

