/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.opensearch.index.fielddata.AbstractSortedDocValues;
import org.opensearch.index.fielddata.ordinals.Ordinals;
import org.opensearch.index.fielddata.ordinals.OrdinalsBuilder;

class SinglePackedOrdinals
extends Ordinals {
    private final PackedInts.Reader reader;
    private final int valueCount;

    public SinglePackedOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        assert (builder.getNumMultiValuesDocs() == 0);
        this.valueCount = (int)builder.getValueCount();
        PackedInts.Mutable reader = PackedInts.getMutable(builder.maxDoc(), PackedInts.bitsRequired(this.valueCount), acceptableOverheadRatio);
        PackedInts.copy(builder.getFirstOrdinals(), 0, reader, 0, builder.maxDoc(), 8192);
        this.reader = reader;
    }

    @Override
    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + this.reader.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("reader", this.reader));
    }

    @Override
    public SortedSetDocValues ordinals(Ordinals.ValuesHolder values) {
        return DocValues.singleton(new Docs(this, values));
    }

    private static class Docs
    extends AbstractSortedDocValues {
        private final int maxOrd;
        private final PackedInts.Reader reader;
        private final Ordinals.ValuesHolder values;
        private int currentDoc = -1;
        private int currentOrd;

        Docs(SinglePackedOrdinals parent, Ordinals.ValuesHolder values) {
            this.maxOrd = parent.valueCount;
            this.reader = parent.reader;
            this.values = values;
        }

        @Override
        public int getValueCount() {
            return this.maxOrd;
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            return this.values.lookupOrd(ord);
        }

        @Override
        public int ordValue() {
            return this.currentOrd;
        }

        @Override
        public boolean advanceExact(int docID) throws IOException {
            this.currentDoc = docID;
            this.currentOrd = (int)(this.reader.get(docID) - 1L);
            return this.currentOrd != -1;
        }

        @Override
        public int docID() {
            return this.currentDoc;
        }
    }
}

