/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.search.DocValueFormat;

public abstract class LeafLongFieldData
implements LeafNumericFieldData {
    private final long ramBytesUsed;
    private final IndexNumericFieldData.NumericType numericType;

    protected LeafLongFieldData(long ramBytesUsed, IndexNumericFieldData.NumericType numericType) {
        this.ramBytesUsed = ramBytesUsed;
        this.numericType = numericType;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        switch (this.numericType) {
            case DATE: {
                return new ScriptDocValues.Dates(this.getLongValues(), false);
            }
            case DATE_NANOSECONDS: {
                assert (this instanceof SortedNumericIndexFieldData.NanoSecondFieldData);
                return new ScriptDocValues.Dates(((SortedNumericIndexFieldData.NanoSecondFieldData)this).getLongValuesAsNanos(), true);
            }
            case BOOLEAN: {
                return new ScriptDocValues.Booleans(this.getLongValues());
            }
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getLongValues());
    }

    @Override
    public final SortedNumericDoubleValues getDoubleValues() {
        return FieldData.castToDouble(this.getLongValues());
    }

    @Override
    public DocValueFetcher.Leaf getLeafValueFetcher(final DocValueFormat format) {
        final SortedNumericDocValues values = this.getLongValues();
        return new DocValueFetcher.Leaf(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() throws IOException {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }

    @Override
    public void close() {
    }
}

