/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;

public final class DerivedFieldQuery
extends Query {
    private final Query query;
    private final Supplier<DerivedFieldValueFetcher> valueFetcherSupplier;
    private final SearchLookup searchLookup;
    private final Analyzer indexAnalyzer;
    private final boolean ignoreMalformed;
    private final Function<Object, IndexableField> indexableFieldGenerator;

    public DerivedFieldQuery(Query query, Supplier<DerivedFieldValueFetcher> valueFetcherSupplier, SearchLookup searchLookup, Analyzer indexAnalyzer, Function<Object, IndexableField> indexableFieldGenerator, boolean ignoreMalformed) {
        this.query = query;
        this.valueFetcherSupplier = valueFetcherSupplier;
        this.searchLookup = searchLookup;
        this.indexAnalyzer = indexAnalyzer;
        this.indexableFieldGenerator = indexableFieldGenerator;
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten == this.query) {
            return this;
        }
        return new DerivedFieldQuery(rewritten, this.valueFetcherSupplier, this.searchLookup, this.indexAnalyzer, this.indexableFieldGenerator, this.ignoreMalformed);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(final LeafReaderContext context) {
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                final DerivedFieldValueFetcher valueFetcher = DerivedFieldQuery.this.valueFetcherSupplier.get();
                valueFetcher.setNextReader(context);
                final LeafSearchLookup leafSearchLookup = DerivedFieldQuery.this.searchLookup.getLeafSearchLookup(context);
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() {
                        List<IndexableField> indexableFields;
                        leafSearchLookup.source().setSegmentAndDocument(context, this.approximation.docID());
                        try {
                            indexableFields = valueFetcher.getIndexableField(leafSearchLookup.source(), DerivedFieldQuery.this.indexableFieldGenerator);
                        }
                        catch (Exception e) {
                            if (DerivedFieldQuery.this.ignoreMalformed) {
                                return false;
                            }
                            throw e;
                        }
                        MemoryIndex memoryIndex = new MemoryIndex();
                        for (IndexableField indexableField : indexableFields) {
                            memoryIndex.addField(indexableField, DerivedFieldQuery.this.indexAnalyzer);
                        }
                        float score = memoryIndex.search(DerivedFieldQuery.this.query);
                        return score > 0.0f;
                    }

                    @Override
                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        DerivedFieldQuery other = (DerivedFieldQuery)o;
        return Objects.equals(this.query, other.query) && Objects.equals(this.indexAnalyzer, other.indexAnalyzer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.query, this.indexAnalyzer);
    }

    @Override
    public String toString(String f) {
        return "DerivedFieldQuery (Query: [ " + this.query.toString(f) + "])";
    }
}

