/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.RankFeatureFieldMapper;
import org.opensearch.index.mapper.RankFeaturesFieldMapper;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryShardContext;

public final class RankFeatureQueryBuilder
extends AbstractQueryBuilder<RankFeatureQueryBuilder> {
    public static final ConstructingObjectParser<RankFeatureQueryBuilder, Void> PARSER = new ConstructingObjectParser("feature", args -> {
        RankFeatureQueryBuilder query;
        String field = (String)args[0];
        float boost = args[1] == null ? 1.0f : ((Float)args[1]).floatValue();
        String queryName = (String)args[2];
        long numNonNulls = Arrays.stream(args, 3, ((Object[])args).length).filter(Objects::nonNull).count();
        if (numNonNulls > 1L) {
            throw new IllegalArgumentException("Can only specify one of [log], [saturation], [sigmoid] and [linear]");
        }
        if (numNonNulls == 0L) {
            query = new RankFeatureQueryBuilder(field, new ScoreFunction.Saturation());
        } else {
            ScoreFunction scoreFunction = (ScoreFunction)Arrays.stream(args, 3, ((Object[])args).length).filter(Objects::nonNull).findAny().get();
            query = new RankFeatureQueryBuilder(field, scoreFunction);
        }
        query.boost(boost);
        query.queryName(queryName);
        return query;
    });
    public static final String NAME = "rank_feature";
    private final String field;
    private final ScoreFunction scoreFunction;

    private static ScoreFunction readScoreFunction(StreamInput in) throws IOException {
        byte b = in.readByte();
        switch (b) {
            case 0: {
                return new ScoreFunction.Log(in);
            }
            case 1: {
                return new ScoreFunction.Saturation(in);
            }
            case 2: {
                return new ScoreFunction.Sigmoid(in);
            }
            case 3: {
                return new ScoreFunction.Linear(in);
            }
        }
        throw new IOException("Illegal score function id: " + b);
    }

    public RankFeatureQueryBuilder(String field, ScoreFunction scoreFunction) {
        this.field = Objects.requireNonNull(field);
        this.scoreFunction = Objects.requireNonNull(scoreFunction);
    }

    public RankFeatureQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.scoreFunction = RankFeatureQueryBuilder.readScoreFunction(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        this.scoreFunction.writeTo(out);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field("field", this.field);
        this.scoreFunction.doXContent(builder);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType ft = context.fieldMapper(this.field);
        if (ft instanceof RankFeatureFieldMapper.RankFeatureFieldType) {
            RankFeatureFieldMapper.RankFeatureFieldType fft = (RankFeatureFieldMapper.RankFeatureFieldType)ft;
            return this.scoreFunction.toQuery("_feature", this.field, fft.positiveScoreImpact());
        }
        if (ft == null) {
            String parentField;
            MappedFieldType parentFt;
            int lastDotIndex = this.field.lastIndexOf(46);
            if (lastDotIndex != -1 && (parentFt = context.fieldMapper(parentField = this.field.substring(0, lastDotIndex))) instanceof RankFeaturesFieldMapper.RankFeaturesFieldType) {
                return this.scoreFunction.toQuery(parentField, this.field.substring(lastDotIndex + 1), true);
            }
            return new MatchNoDocsQuery();
        }
        throw new IllegalArgumentException("[rank_feature] query only works on [rank_feature] fields and features of [rank_features] fields, not [" + ft.typeName() + "]");
    }

    @Override
    protected boolean doEquals(RankFeatureQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.scoreFunction, other.scoreFunction);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.field, this.scoreFunction);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("field", new String[0]));
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), BOOST_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ScoreFunction.Log.PARSER, new ParseField("log", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ScoreFunction.Saturation.PARSER, new ParseField("saturation", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ScoreFunction.Sigmoid.PARSER, new ParseField("sigmoid", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ScoreFunction.Linear.PARSER, new ParseField("linear", new String[0]));
    }

    public static abstract class ScoreFunction {
        private ScoreFunction() {
        }

        abstract void writeTo(StreamOutput var1) throws IOException;

        abstract Query toQuery(String var1, String var2, boolean var3) throws IOException;

        abstract void doXContent(XContentBuilder var1) throws IOException;

        public static class Linear
        extends ScoreFunction {
            private static final ObjectParser<Linear, Void> PARSER = new ObjectParser("linear", Linear::new);

            public Linear() {
            }

            private Linear(StreamInput in) {
                this();
            }

            public boolean equals(Object obj) {
                return obj != null && this.getClass() == obj.getClass();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            @Override
            void writeTo(StreamOutput out) throws IOException {
                out.writeByte((byte)3);
            }

            @Override
            void doXContent(XContentBuilder builder) throws IOException {
                builder.startObject("linear");
                builder.endObject();
            }

            @Override
            Query toQuery(String field, String feature, boolean positiveScoreImpact) throws IOException {
                return FeatureField.newLinearQuery(field, feature, 1.0f);
            }
        }

        public static class Sigmoid
        extends ScoreFunction {
            private static final ConstructingObjectParser<Sigmoid, Void> PARSER = new ConstructingObjectParser("sigmoid", a -> new Sigmoid(((Float)a[0]).floatValue(), ((Float)a[1]).floatValue()));
            private final float pivot;
            private final float exp;

            public Sigmoid(float pivot, float exp) {
                this.pivot = pivot;
                this.exp = exp;
            }

            private Sigmoid(StreamInput in) throws IOException {
                this(in.readFloat(), in.readFloat());
            }

            public boolean equals(Object obj) {
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Sigmoid that = (Sigmoid)obj;
                return this.pivot == that.pivot && this.exp == that.exp;
            }

            public int hashCode() {
                return Objects.hash(Float.valueOf(this.pivot), Float.valueOf(this.exp));
            }

            @Override
            void writeTo(StreamOutput out) throws IOException {
                out.writeByte((byte)2);
                out.writeFloat(this.pivot);
                out.writeFloat(this.exp);
            }

            @Override
            void doXContent(XContentBuilder builder) throws IOException {
                builder.startObject("sigmoid");
                builder.field("pivot", this.pivot);
                builder.field("exponent", this.exp);
                builder.endObject();
            }

            @Override
            Query toQuery(String field, String feature, boolean positiveScoreImpact) throws IOException {
                return FeatureField.newSigmoidQuery(field, feature, 1.0f, this.pivot, this.exp);
            }

            static {
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("pivot", new String[0]));
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("exponent", new String[0]));
            }
        }

        public static class Saturation
        extends ScoreFunction {
            private static final ConstructingObjectParser<Saturation, Void> PARSER = new ConstructingObjectParser("saturation", a -> new Saturation((Float)a[0]));
            private final Float pivot;

            public Saturation() {
                this((Float)null);
            }

            public Saturation(float pivot) {
                this(Float.valueOf(pivot));
            }

            private Saturation(Float pivot) {
                this.pivot = pivot;
            }

            private Saturation(StreamInput in) throws IOException {
                this(in.readOptionalFloat());
            }

            public boolean equals(Object obj) {
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Saturation that = (Saturation)obj;
                return Objects.equals(this.pivot, that.pivot);
            }

            public int hashCode() {
                return Objects.hashCode(this.pivot);
            }

            @Override
            void writeTo(StreamOutput out) throws IOException {
                out.writeByte((byte)1);
                out.writeOptionalFloat(this.pivot);
            }

            @Override
            void doXContent(XContentBuilder builder) throws IOException {
                builder.startObject("saturation");
                if (this.pivot != null) {
                    builder.field("pivot", this.pivot);
                }
                builder.endObject();
            }

            @Override
            Query toQuery(String field, String feature, boolean positiveScoreImpact) throws IOException {
                if (this.pivot == null) {
                    return FeatureField.newSaturationQuery(field, feature);
                }
                return FeatureField.newSaturationQuery(field, feature, 1.0f, this.pivot.floatValue());
            }

            static {
                PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), new ParseField("pivot", new String[0]));
            }
        }

        public static class Log
        extends ScoreFunction {
            private static final ConstructingObjectParser<Log, Void> PARSER = new ConstructingObjectParser("log", a -> new Log(((Float)a[0]).floatValue()));
            private final float scalingFactor;

            public Log(float scalingFactor) {
                this.scalingFactor = scalingFactor;
            }

            private Log(StreamInput in) throws IOException {
                this(in.readFloat());
            }

            public boolean equals(Object obj) {
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Log that = (Log)obj;
                return this.scalingFactor == that.scalingFactor;
            }

            public int hashCode() {
                return Float.hashCode(this.scalingFactor);
            }

            @Override
            void writeTo(StreamOutput out) throws IOException {
                out.writeByte((byte)0);
                out.writeFloat(this.scalingFactor);
            }

            @Override
            void doXContent(XContentBuilder builder) throws IOException {
                builder.startObject("log");
                builder.field("scaling_factor", this.scalingFactor);
                builder.endObject();
            }

            @Override
            Query toQuery(String field, String feature, boolean positiveScoreImpact) throws IOException {
                if (!positiveScoreImpact) {
                    throw new IllegalArgumentException("Cannot use the [log] function with a field that has a negative score impact as it would trigger negative scores");
                }
                return FeatureField.newLogQuery(field, feature, 1.0f, this.scalingFactor);
            }

            static {
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("scaling_factor", new String[0]));
            }
        }
    }
}

