/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.fs;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.monitor.NodeHealthService;
import org.opensearch.monitor.StatusInfo;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class FsHealthService
extends AbstractLifecycleComponent
implements NodeHealthService {
    private static final Logger logger = LogManager.getLogger(FsHealthService.class);
    private final ThreadPool threadPool;
    private volatile boolean enabled;
    private volatile boolean brokenLock;
    private final TimeValue refreshInterval;
    private volatile TimeValue slowPathLoggingThreshold;
    private final NodeEnvironment nodeEnv;
    private final LongSupplier currentTimeMillisSupplier;
    private volatile Scheduler.Cancellable scheduledFuture;
    private volatile TimeValue healthyTimeoutThreshold;
    private final AtomicLong lastRunStartTimeMillis = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean checkInProgress = new AtomicBoolean();
    @Nullable
    private volatile Set<Path> unhealthyPaths;
    public static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting("monitor.fs.health.enabled", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.fs.health.refresh_interval", TimeValue.timeValueSeconds(60L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> SLOW_PATH_LOGGING_THRESHOLD_SETTING = Setting.timeSetting("monitor.fs.health.slow_path_logging_threshold", TimeValue.timeValueSeconds(5L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> HEALTHY_TIMEOUT_SETTING = Setting.timeSetting("monitor.fs.health.healthy_timeout_threshold", TimeValue.timeValueSeconds(60L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope, Setting.Property.Dynamic);

    public FsHealthService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, NodeEnvironment nodeEnv) {
        this.threadPool = threadPool;
        this.enabled = ENABLED_SETTING.get(settings);
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.slowPathLoggingThreshold = SLOW_PATH_LOGGING_THRESHOLD_SETTING.get(settings);
        this.currentTimeMillisSupplier = threadPool::relativeTimeInMillis;
        this.healthyTimeoutThreshold = HEALTHY_TIMEOUT_SETTING.get(settings);
        this.nodeEnv = nodeEnv;
        clusterSettings.addSettingsUpdateConsumer(SLOW_PATH_LOGGING_THRESHOLD_SETTING, this::setSlowPathLoggingThreshold);
        clusterSettings.addSettingsUpdateConsumer(HEALTHY_TIMEOUT_SETTING, this::setHealthyTimeoutThreshold);
        clusterSettings.addSettingsUpdateConsumer(ENABLED_SETTING, this::setEnabled);
    }

    @Override
    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(new FsHealthMonitor(), this.refreshInterval, "generic");
    }

    @Override
    protected void doStop() {
        this.scheduledFuture.cancel();
    }

    @Override
    protected void doClose() {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSlowPathLoggingThreshold(TimeValue slowPathLoggingThreshold) {
        this.slowPathLoggingThreshold = slowPathLoggingThreshold;
    }

    public void setHealthyTimeoutThreshold(TimeValue healthyTimeoutThreshold) {
        this.healthyTimeoutThreshold = healthyTimeoutThreshold;
    }

    @Override
    public StatusInfo getHealth() {
        StatusInfo statusInfo;
        Set<Path> unhealthyPaths = this.unhealthyPaths;
        if (!this.enabled) {
            statusInfo = new StatusInfo(StatusInfo.Status.HEALTHY, "health check disabled");
        } else if (this.brokenLock) {
            statusInfo = new StatusInfo(StatusInfo.Status.UNHEALTHY, "health check failed due to broken node lock");
        } else if (this.checkInProgress.get() && this.currentTimeMillisSupplier.getAsLong() - this.lastRunStartTimeMillis.get() > this.healthyTimeoutThreshold.millis()) {
            statusInfo = new StatusInfo(StatusInfo.Status.UNHEALTHY, "healthy threshold breached");
        } else if (unhealthyPaths == null) {
            statusInfo = new StatusInfo(StatusInfo.Status.HEALTHY, "health check passed");
        } else {
            String info = "health check failed on [" + unhealthyPaths.stream().map(k -> k.toString()).collect(Collectors.joining(",")) + "]";
            statusInfo = new StatusInfo(StatusInfo.Status.UNHEALTHY, info);
        }
        return statusInfo;
    }

    private void setLastRunStartTimeMillis() {
        this.lastRunStartTimeMillis.getAndUpdate(l -> Math.max(l, this.currentTimeMillisSupplier.getAsLong()));
    }

    class FsHealthMonitor
    implements Runnable {
        static final String TEMP_FILE_NAME = ".opensearch_temp_file";
        private byte[] byteToWrite = UUIDs.randomBase64UUID().getBytes(StandardCharsets.UTF_8);

        FsHealthMonitor() {
        }

        @Override
        public void run() {
            block7: {
                boolean checkEnabled = FsHealthService.this.enabled;
                try {
                    if (checkEnabled) {
                        FsHealthService.this.setLastRunStartTimeMillis();
                        boolean started = FsHealthService.this.checkInProgress.compareAndSet(false, true);
                        assert (started);
                        this.monitorFSHealth();
                        logger.debug("health check succeeded");
                    }
                }
                catch (Exception e) {
                    logger.error("health check failed", (Throwable)e);
                }
                finally {
                    if (!checkEnabled) break block7;
                    boolean completed = FsHealthService.this.checkInProgress.compareAndSet(true, false);
                    if ($assertionsDisabled || completed) break block7;
                    throw new AssertionError();
                }
            }
        }

        private void monitorFSHealth() {
            HashSet<Path> currentUnhealthyPaths = null;
            Path[] paths = null;
            try {
                paths = FsHealthService.this.nodeEnv.nodeDataPaths();
            }
            catch (IllegalStateException e) {
                logger.error("health check failed", (Throwable)e);
                FsHealthService.this.brokenLock = true;
                return;
            }
            for (Path path : paths) {
                long executionStartTime = FsHealthService.this.currentTimeMillisSupplier.getAsLong();
                try {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    Path tempDataPath = path.resolve(TEMP_FILE_NAME);
                    Files.deleteIfExists(tempDataPath);
                    try (OutputStream os = Files.newOutputStream(tempDataPath, StandardOpenOption.CREATE_NEW);){
                        os.write(this.byteToWrite);
                        IOUtils.fsync(tempDataPath, false);
                    }
                    Files.delete(tempDataPath);
                    long elapsedTime = FsHealthService.this.currentTimeMillisSupplier.getAsLong() - executionStartTime;
                    if (elapsedTime > FsHealthService.this.slowPathLoggingThreshold.millis()) {
                        logger.warn("health check of [{}] took [{}ms] which is above the warn threshold of [{}]", (Object)path, (Object)elapsedTime, (Object)FsHealthService.this.slowPathLoggingThreshold);
                    }
                    if (elapsedTime <= FsHealthService.this.healthyTimeoutThreshold.millis()) continue;
                    logger.error("health check of [{}] failed, took [{}ms] which is above the healthy threshold of [{}]", (Object)path, (Object)elapsedTime, (Object)FsHealthService.this.healthyTimeoutThreshold);
                    if (currentUnhealthyPaths == null) {
                        currentUnhealthyPaths = new HashSet(1);
                    }
                    currentUnhealthyPaths.add(path);
                }
                catch (Exception ex) {
                    logger.error((Message)new ParameterizedMessage("health check of [{}] failed", (Object)path), (Throwable)ex);
                    if (currentUnhealthyPaths == null) {
                        currentUnhealthyPaths = new HashSet<Path>(1);
                    }
                    currentUnhealthyPaths.add(path);
                }
            }
            FsHealthService.this.unhealthyPaths = currentUnhealthyPaths;
            FsHealthService.this.brokenLock = false;
        }
    }
}

