/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlService;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;

public class AdmissionControlTransportHandler<T extends TransportRequest>
implements TransportRequestHandler<T> {
    private final String action;
    private final TransportRequestHandler<T> actualHandler;
    protected final Logger log = LogManager.getLogger(this.getClass());
    AdmissionControlService admissionControlService;
    boolean forceExecution;
    AdmissionControlActionType admissionControlActionType;

    public AdmissionControlTransportHandler(String action, TransportRequestHandler<T> actualHandler, AdmissionControlService admissionControlService, boolean forceExecution, AdmissionControlActionType admissionControlActionType) {
        this.action = action;
        this.actualHandler = actualHandler;
        this.admissionControlService = admissionControlService;
        this.forceExecution = forceExecution;
        this.admissionControlActionType = admissionControlActionType;
    }

    @Override
    public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
        if (!this.forceExecution) {
            try {
                this.admissionControlService.applyTransportAdmissionControl(this.action, this.admissionControlActionType);
            }
            catch (OpenSearchRejectedExecutionException openSearchRejectedExecutionException) {
                this.log.warn(openSearchRejectedExecutionException.getMessage());
                channel.sendResponse(openSearchRejectedExecutionException);
                return;
            }
        }
        this.actualHandler.messageReceived(request, channel, task);
    }
}

