/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationFactory;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.MultiTermsValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;

public class MultiTermsAggregationBuilder
extends AbstractAggregationBuilder<MultiTermsAggregationBuilder> {
    public static final String NAME = "multi_terms";
    public static final ObjectParser<MultiTermsAggregationBuilder, String> PARSER = ObjectParser.fromBuilder("multi_terms", MultiTermsAggregationBuilder::new);
    public static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    public static final ParseField SHARD_SIZE_FIELD_NAME = new ParseField("shard_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD_NAME = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD_NAME = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField REQUIRED_SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    public static final ParseField SHOW_TERM_DOC_COUNT_ERROR = new ParseField("show_term_doc_count_error", new String[0]);
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ValuesSourceRegistry.RegistryKey<MultiTermsAggregationFactory.InternalValuesSourceSupplier> REGISTRY_KEY;
    private List<MultiTermsValuesSourceConfig> terms;
    private BucketOrder order = BucketOrder.compound(BucketOrder.count(false));
    private Aggregator.SubAggCollectionMode collectMode = null;
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS);
    private boolean showTermDocCountError = false;

    @Override
    public String getType() {
        return NAME;
    }

    public MultiTermsAggregationBuilder(String name) {
        super(name);
    }

    protected MultiTermsAggregationBuilder(MultiTermsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.terms = new ArrayList<MultiTermsValuesSourceConfig>(clone.terms);
        this.order = clone.order;
        this.collectMode = clone.collectMode;
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(clone.bucketCountThresholds);
        this.showTermDocCountError = clone.showTermDocCountError;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new MultiTermsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public MultiTermsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.terms = in.readList(MultiTermsValuesSourceConfig::new);
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(in);
        this.collectMode = in.readOptionalWriteable(Aggregator.SubAggCollectionMode::readFromStream);
        this.order = InternalOrder.Streams.readOrder(in);
        this.showTermDocCountError = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeList(this.terms);
        this.bucketCountThresholds.writeTo(out);
        out.writeOptionalWriteable(this.collectMode);
        this.order.writeTo(out);
        out.writeBoolean(this.showTermDocCountError);
    }

    @Override
    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        return new MultiTermsAggregationFactory(this.name, queryShardContext, parent, subfactoriesBuilder, this.metadata, this.terms, this.order, this.collectMode, this.bucketCountThresholds, this.showTermDocCountError);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.terms != null) {
            builder.field(TERMS_FIELD.getPreferredName(), this.terms);
        }
        this.bucketCountThresholds.toXContent(builder, params);
        builder.field(SHOW_TERM_DOC_COUNT_ERROR.getPreferredName(), this.showTermDocCountError);
        builder.field(ORDER_FIELD.getPreferredName());
        this.order.toXContent(builder, params);
        if (this.collectMode != null) {
            builder.field(Aggregator.SubAggCollectionMode.KEY.getPreferredName(), this.collectMode.parseField().getPreferredName());
        }
        builder.endObject();
        return builder;
    }

    public MultiTermsAggregationBuilder terms(List<MultiTermsValuesSourceConfig> terms) {
        if (terms == null) {
            throw new IllegalArgumentException("[terms] must not be null. Found null terms in [" + this.name + "]");
        }
        if (terms.size() < 2) {
            throw new IllegalArgumentException("multi term aggregation must has at least 2 terms. Found [" + terms.size() + "] in [" + this.name + "]" + (terms.size() == 1 ? " Use terms aggregation for single term aggregation" : ""));
        }
        this.terms = terms;
        return this;
    }

    public MultiTermsAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public int size() {
        return this.bucketCountThresholds.getRequiredSize();
    }

    public MultiTermsAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public int shardSize() {
        return this.bucketCountThresholds.getShardSize();
    }

    public MultiTermsAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public long minDocCount() {
        return this.bucketCountThresholds.getMinDocCount();
    }

    public MultiTermsAggregationBuilder shardMinDocCount(long shardMinDocCount) {
        if (shardMinDocCount < 0L) {
            throw new IllegalArgumentException("[shardMinDocCount] must be greater than or equal to 0. Found [" + shardMinDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public long shardMinDocCount() {
        return this.bucketCountThresholds.getShardMinDocCount();
    }

    public MultiTermsAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder(order) ? order : BucketOrder.compound(order);
        return this;
    }

    public MultiTermsAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public MultiTermsAggregationBuilder collectMode(Aggregator.SubAggCollectionMode collectMode) {
        if (collectMode == null) {
            throw new IllegalArgumentException("[collectMode] must not be null: [" + this.name + "]");
        }
        this.collectMode = collectMode;
        return this;
    }

    public Aggregator.SubAggCollectionMode collectMode() {
        return this.collectMode;
    }

    public boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    public MultiTermsAggregationBuilder showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketCountThresholds, this.collectMode, this.order, this.showTermDocCountError);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MultiTermsAggregationBuilder other = (MultiTermsAggregationBuilder)obj;
        return Objects.equals(this.terms, other.terms) && Objects.equals(this.bucketCountThresholds, other.bucketCountThresholds) && Objects.equals(this.collectMode, other.collectMode) && Objects.equals(this.order, other.order) && Objects.equals(this.showTermDocCountError, other.showTermDocCountError);
    }

    static {
        ObjectParser<MultiTermsValuesSourceConfig.Builder, Void> parser = MultiTermsValuesSourceConfig.PARSER.apply(true, true, true, true);
        PARSER.declareObjectArray(MultiTermsAggregationBuilder::terms, (p, c) -> ((MultiTermsValuesSourceConfig.Builder)parser.parse(p, null)).build(), TERMS_FIELD);
        PARSER.declareBoolean(MultiTermsAggregationBuilder::showTermDocCountError, SHOW_TERM_DOC_COUNT_ERROR);
        PARSER.declareInt(MultiTermsAggregationBuilder::shardSize, SHARD_SIZE_FIELD_NAME);
        PARSER.declareLong(MultiTermsAggregationBuilder::minDocCount, MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareLong(MultiTermsAggregationBuilder::shardMinDocCount, SHARD_MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareInt(MultiTermsAggregationBuilder::size, REQUIRED_SIZE_FIELD_NAME);
        PARSER.declareObjectArray(MultiTermsAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam(p), ORDER_FIELD);
        PARSER.declareField(MultiTermsAggregationBuilder::collectMode, (p, c) -> Aggregator.SubAggCollectionMode.parse(p.text(), LoggingDeprecationHandler.INSTANCE), Aggregator.SubAggCollectionMode.KEY, ObjectParser.ValueType.STRING);
        REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<MultiTermsAggregationFactory.InternalValuesSourceSupplier>(NAME, MultiTermsAggregationFactory.InternalValuesSourceSupplier.class);
    }
}

