/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.tasks.TaskCancelledException;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.fieldvisitor.CustomFieldsVisitor;
import org.opensearch.index.fieldvisitor.FieldsVisitor;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.search.SearchContextSourcePrinter;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchPhaseExecutionException;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.opensearch.search.fetch.StoredFieldsContext;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.fetch.subphase.InnerHitsPhase;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;

@PublicApi(since="1.0.0")
public class FetchPhase {
    private static final Logger LOGGER = LogManager.getLogger(FetchPhase.class);
    private final FetchSubPhase[] fetchSubPhases;

    public FetchPhase(List<FetchSubPhase> fetchSubPhases) {
        this.fetchSubPhases = fetchSubPhases.toArray(new FetchSubPhase[fetchSubPhases.size() + 1]);
        this.fetchSubPhases[fetchSubPhases.size()] = new InnerHitsPhase(this);
    }

    public void execute(SearchContext context) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(context));
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
        }
        if (context.docIdsToLoadSize() == 0) {
            context.fetchResult().hits(new SearchHits(new SearchHit[0], context.queryResult().getTotalHits(), context.queryResult().getMaxScore()));
            return;
        }
        Object[] docs = new DocIdToIndex[context.docIdsToLoadSize()];
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            docs[index] = new DocIdToIndex(context.docIdsToLoad()[context.docIdsToLoadFrom() + index], index);
        }
        Arrays.sort(docs);
        HashMap<String, Set<String>> storedToRequestedFields = new HashMap<String, Set<String>>();
        FieldsVisitor fieldsVisitor = this.createStoredFieldsVisitor(context, storedToRequestedFields);
        FetchContext fetchContext = new FetchContext(context);
        SearchHit[] hits = new SearchHit[context.docIdsToLoadSize()];
        List<FetchSubPhaseProcessor> processors = this.getProcessors(context.shardTarget(), fetchContext);
        int currentReaderIndex = -1;
        LeafReaderContext currentReaderContext = null;
        CheckedBiConsumer fieldReader = null;
        boolean hasSequentialDocs = FetchPhase.hasSequentialDocs((DocIdToIndex[])docs);
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            if (context.isCancelled()) {
                throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
            }
            int docId = ((DocIdToIndex)docs[index]).docId;
            try {
                int readerIndex = ReaderUtil.subIndex(docId, context.searcher().getIndexReader().leaves());
                if (currentReaderIndex != readerIndex) {
                    currentReaderContext = context.searcher().getIndexReader().leaves().get(readerIndex);
                    currentReaderIndex = readerIndex;
                    if (currentReaderContext.reader() instanceof SequentialStoredFieldsLeafReader && hasSequentialDocs && docs.length >= 10) {
                        SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)currentReaderContext.reader();
                        fieldReader = lf.getSequentialStoredFieldsReader()::document;
                    } else {
                        fieldReader = currentReaderContext.reader().storedFields()::document;
                    }
                    for (FetchSubPhaseProcessor processor : processors) {
                        processor.setNextReader(currentReaderContext);
                    }
                }
                assert (currentReaderContext != null);
                FetchSubPhase.HitContext hit = this.prepareHitContext(context, fetchContext.searchLookup(), fieldsVisitor, docId, storedToRequestedFields, currentReaderContext, fieldReader);
                for (FetchSubPhaseProcessor processor : processors) {
                    processor.process(hit);
                }
                hits[((DocIdToIndex)docs[index]).index] = hit.hit();
                continue;
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context.shardTarget(), "Error running fetch phase for doc [" + docId + "]", e);
            }
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
        }
        TotalHits totalHits = context.queryResult().getTotalHits();
        context.fetchResult().hits(new SearchHits(hits, totalHits, context.queryResult().getMaxScore()));
    }

    List<FetchSubPhaseProcessor> getProcessors(SearchShardTarget target, FetchContext context) {
        try {
            ArrayList<FetchSubPhaseProcessor> processors = new ArrayList<FetchSubPhaseProcessor>();
            for (FetchSubPhase fsp : this.fetchSubPhases) {
                FetchSubPhaseProcessor processor = fsp.getProcessor(context);
                if (processor == null) continue;
                processors.add(processor);
            }
            return processors;
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(target, "Error building fetch sub-phases", e);
        }
    }

    protected FieldsVisitor createStoredFieldsVisitor(SearchContext context, Map<String, Set<String>> storedToRequestedFields) {
        StoredFieldsContext storedFieldsContext = context.storedFieldsContext();
        if (storedFieldsContext == null) {
            if (!context.hasScriptFields() && !context.hasFetchSourceContext()) {
                context.fetchSourceContext(new FetchSourceContext(true));
            }
            boolean loadSource = this.sourceRequired(context);
            return new FieldsVisitor(loadSource, context.hasFetchSourceContext() ? context.fetchSourceContext().includes() : null, context.hasFetchSourceContext() ? context.fetchSourceContext().excludes() : null);
        }
        if (!storedFieldsContext.fetchFields()) {
            return null;
        }
        for (String fieldNameOrPattern : context.storedFieldsContext().fieldNames()) {
            if (fieldNameOrPattern.equals("_source")) {
                FetchSourceContext fetchSourceContext = context.hasFetchSourceContext() ? context.fetchSourceContext() : FetchSourceContext.FETCH_SOURCE;
                context.fetchSourceContext(new FetchSourceContext(true, fetchSourceContext.includes(), fetchSourceContext.excludes()));
                continue;
            }
            Set<String> fieldNames = context.mapperService().simpleMatchToFullName(fieldNameOrPattern);
            for (String fieldName : fieldNames) {
                MappedFieldType fieldType = context.fieldType(fieldName);
                if (fieldType == null) {
                    if (context.getObjectMapper(fieldName) == null) continue;
                    throw new IllegalArgumentException("field [" + fieldName + "] isn't a leaf field");
                }
                String storedField = fieldType.name();
                Set requestedFields = storedToRequestedFields.computeIfAbsent(storedField, key -> new HashSet());
                requestedFields.add(fieldName);
            }
        }
        boolean loadSource = this.sourceRequired(context);
        if (storedToRequestedFields.isEmpty()) {
            return new FieldsVisitor(loadSource, context.hasFetchSourceContext() ? context.fetchSourceContext().includes() : null, context.hasFetchSourceContext() ? context.fetchSourceContext().excludes() : null);
        }
        return new CustomFieldsVisitor(storedToRequestedFields.keySet(), loadSource, context.hasFetchSourceContext() ? context.fetchSourceContext().includes() : null, context.hasFetchSourceContext() ? context.fetchSourceContext().excludes() : null);
    }

    private boolean sourceRequired(SearchContext context) {
        return context.sourceRequested() || context.fetchFieldsContext() != null;
    }

    private int findRootDocumentIfNested(SearchContext context, LeafReaderContext subReaderContext, int subDocId) throws IOException {
        BitSet bits;
        if (context.mapperService().hasNested() && !(bits = context.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter()).getBitSet(subReaderContext)).get(subDocId)) {
            return bits.nextSetBit(subDocId);
        }
        return -1;
    }

    private FetchSubPhase.HitContext prepareHitContext(SearchContext context, SearchLookup lookup, FieldsVisitor fieldsVisitor, int docId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, FieldsVisitor, IOException> storedFieldReader) throws IOException {
        int rootDocId = this.findRootDocumentIfNested(context, subReaderContext, docId - subReaderContext.docBase);
        if (rootDocId == -1) {
            return this.prepareNonNestedHitContext(context, lookup, fieldsVisitor, docId, storedToRequestedFields, subReaderContext, storedFieldReader);
        }
        return this.prepareNestedHitContext(context, docId, rootDocId, storedToRequestedFields, subReaderContext, storedFieldReader);
    }

    private FetchSubPhase.HitContext prepareNonNestedHitContext(SearchContext context, SearchLookup lookup, FieldsVisitor fieldsVisitor, int docId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, FieldsVisitor, IOException> fieldReader) throws IOException {
        SearchHit hit;
        int subDocId = docId - subReaderContext.docBase;
        DocumentMapper documentMapper = context.mapperService().documentMapper();
        Text typeText = documentMapper.typeText();
        if (fieldsVisitor == null) {
            SearchHit hit2 = new SearchHit(docId, null, null, null);
            return new FetchSubPhase.HitContext(hit2, subReaderContext, subDocId, lookup.source());
        }
        this.loadStoredFields(context::fieldType, fieldReader, fieldsVisitor, subDocId);
        String id = fieldsVisitor.id();
        if (!fieldsVisitor.fields().isEmpty()) {
            HashMap<String, DocumentField> docFields = new HashMap<String, DocumentField>();
            HashMap<String, DocumentField> metaFields = new HashMap<String, DocumentField>();
            FetchPhase.fillDocAndMetaFields(context, fieldsVisitor, storedToRequestedFields, docFields, metaFields);
            hit = new SearchHit(docId, id, docFields, metaFields);
        } else {
            hit = new SearchHit(docId, id, Collections.emptyMap(), Collections.emptyMap());
        }
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(hit, subReaderContext, subDocId, lookup.source());
        if (fieldsVisitor.source() != null) {
            hitContext.sourceLookup().setSource(fieldsVisitor.source());
        }
        return hitContext;
    }

    private FetchSubPhase.HitContext prepareNestedHitContext(SearchContext context, int nestedTopDocId, int rootDocId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, FieldsVisitor, IOException> storedFieldReader) throws IOException {
        String rootId;
        boolean needSource = this.sourceRequired(context) || context.highlight() != null;
        Map<String, Object> rootSourceAsMap = null;
        MediaType rootSourceContentType = null;
        int nestedDocId = nestedTopDocId - subReaderContext.docBase;
        if (context instanceof InnerHitsContext.InnerHitSubContext) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)context;
            rootId = innerHitsContext.getId();
            if (needSource) {
                SourceLookup rootLookup = innerHitsContext.getRootLookup();
                rootSourceAsMap = rootLookup.loadSourceIfNeeded();
                rootSourceContentType = rootLookup.sourceContentType();
            }
        } else {
            FieldsVisitor rootFieldsVisitor = new FieldsVisitor(needSource);
            this.loadStoredFields(context::fieldType, storedFieldReader, rootFieldsVisitor, rootDocId);
            rootFieldsVisitor.postProcess(context::fieldType);
            rootId = rootFieldsVisitor.id();
            if (needSource) {
                if (rootFieldsVisitor.source() != null) {
                    Tuple<XContentType, Map<String, Object>> tuple = XContentHelper.convertToMap(rootFieldsVisitor.source(), false);
                    rootSourceAsMap = tuple.v2();
                    rootSourceContentType = tuple.v1();
                } else {
                    rootSourceAsMap = Collections.emptyMap();
                }
            }
        }
        Map<String, DocumentField> docFields = Collections.emptyMap();
        Map<String, DocumentField> metaFields = Collections.emptyMap();
        if (context.hasStoredFields() && !context.storedFieldsContext().fieldNames().isEmpty()) {
            CustomFieldsVisitor nestedFieldsVisitor = new CustomFieldsVisitor(storedToRequestedFields.keySet(), false);
            this.loadStoredFields(context::fieldType, storedFieldReader, nestedFieldsVisitor, nestedDocId);
            if (!nestedFieldsVisitor.fields().isEmpty()) {
                docFields = new HashMap<String, DocumentField>();
                metaFields = new HashMap<String, DocumentField>();
                FetchPhase.fillDocAndMetaFields(context, nestedFieldsVisitor, storedToRequestedFields, docFields, metaFields);
            }
        }
        DocumentMapper documentMapper = context.mapperService().documentMapper();
        ObjectMapper nestedObjectMapper = documentMapper.findNestedObjectMapper(nestedDocId, context, subReaderContext);
        assert (nestedObjectMapper != null);
        SearchHit.NestedIdentity nestedIdentity = this.getInternalNestedIdentity(context, nestedDocId, subReaderContext, context.mapperService(), nestedObjectMapper);
        SearchHit hit = new SearchHit(nestedTopDocId, rootId, nestedIdentity, docFields, metaFields);
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(hit, subReaderContext, nestedDocId, new SourceLookup());
        if (rootSourceAsMap != null && !rootSourceAsMap.isEmpty()) {
            HashMap<String, Object> nestedSourceAsMap;
            HashMap<String, Object> current = nestedSourceAsMap = new HashMap<String, Object>();
            for (SearchHit.NestedIdentity nested = nestedIdentity; nested != null; nested = nested.getChild()) {
                List<Object> nestedParsedSource;
                String nestedPath = nested.getField().string();
                current.put(nestedPath, new HashMap());
                Object extractedValue = XContentMapValues.extractValue(nestedPath, rootSourceAsMap);
                if (extractedValue instanceof List) {
                    nestedParsedSource = (List<Object>)extractedValue;
                } else if (extractedValue instanceof Map) {
                    nestedParsedSource = Collections.singletonList(extractedValue);
                } else {
                    throw new IllegalStateException("extracted source isn't an object or an array");
                }
                if (!(nestedParsedSource.get(0) instanceof Map) && !nestedObjectMapper.parentObjectMapperAreNested(context.mapperService())) {
                    throw new IllegalArgumentException("Cannot execute inner hits. One or more parent object fields of nested field [" + nestedObjectMapper.name() + "] are not nested. All parent fields need to be nested fields too");
                }
                rootSourceAsMap = (Map)nestedParsedSource.get(nested.getOffset());
                if (nested.getChild() == null) {
                    current.put(nestedPath, rootSourceAsMap);
                    continue;
                }
                HashMap next = new HashMap();
                current.put(nestedPath, next);
                current = next;
            }
            hitContext.sourceLookup().setSource(nestedSourceAsMap);
            hitContext.sourceLookup().setSourceContentType(rootSourceContentType);
        }
        return hitContext;
    }

    private SearchHit.NestedIdentity getInternalNestedIdentity(SearchContext context, int nestedSubDocId, LeafReaderContext subReaderContext, MapperService mapperService, ObjectMapper nestedObjectMapper) throws IOException {
        int currentParent = nestedSubDocId;
        ObjectMapper current = nestedObjectMapper;
        String originalName = nestedObjectMapper.name();
        SearchHit.NestedIdentity nestedIdentity = null;
        do {
            Query parentFilter;
            ObjectMapper nestedParentObjectMapper;
            if ((nestedParentObjectMapper = current.getParentObjectMapper(mapperService)) != null) {
                if (!nestedParentObjectMapper.nested().isNested()) {
                    current = nestedParentObjectMapper;
                    continue;
                }
                parentFilter = nestedParentObjectMapper.nestedTypeFilter();
            } else {
                parentFilter = Queries.newNonNestedFilter();
            }
            Query childFilter = nestedObjectMapper.nestedTypeFilter();
            if (childFilter == null) {
                current = nestedParentObjectMapper;
                continue;
            }
            BitSet childIter = context.bitsetFilterCache().getBitSetProducer(context.searcher().rewrite(childFilter)).getBitSet(subReaderContext);
            if (childIter == null) {
                current = nestedParentObjectMapper;
                continue;
            }
            BitSet parentBits = context.bitsetFilterCache().getBitSetProducer(parentFilter).getBitSet(subReaderContext);
            int offset = 0;
            int previousParent = parentBits.prevSetBit(currentParent);
            int docId = childIter.nextSetBit(previousParent + 1);
            while (docId < nestedSubDocId && docId != Integer.MAX_VALUE) {
                ++offset;
                docId = childIter.nextSetBit(docId + 1);
            }
            currentParent = nestedSubDocId;
            nestedObjectMapper = nestedParentObjectMapper;
            current = nestedObjectMapper;
            int currentPrefix = current == null ? 0 : current.name().length() + 1;
            nestedIdentity = new SearchHit.NestedIdentity(originalName.substring(currentPrefix), offset, nestedIdentity);
            if (current == null) continue;
            originalName = current.name();
        } while (current != null);
        return nestedIdentity;
    }

    private void loadStoredFields(Function<String, MappedFieldType> fieldTypeLookup, CheckedBiConsumer<Integer, FieldsVisitor, IOException> fieldReader, FieldsVisitor fieldVisitor, int docId) throws IOException {
        fieldVisitor.reset();
        fieldReader.accept(docId, fieldVisitor);
        fieldVisitor.postProcess(fieldTypeLookup);
    }

    private static void fillDocAndMetaFields(SearchContext context, FieldsVisitor fieldsVisitor, Map<String, Set<String>> storedToRequestedFields, Map<String, DocumentField> docFields, Map<String, DocumentField> metaFields) {
        for (Map.Entry<String, List<Object>> entry : fieldsVisitor.fields().entrySet()) {
            String storedField = entry.getKey();
            List<Object> storedValues = entry.getValue();
            if (storedToRequestedFields.containsKey(storedField)) {
                for (String requestedField : storedToRequestedFields.get(storedField)) {
                    if (context.mapperService().isMetadataField(requestedField)) {
                        metaFields.put(requestedField, new DocumentField(requestedField, storedValues));
                        continue;
                    }
                    docFields.put(requestedField, new DocumentField(requestedField, storedValues));
                }
                continue;
            }
            if (context.mapperService().isMetadataField(storedField)) {
                metaFields.put(storedField, new DocumentField(storedField, storedValues));
                continue;
            }
            docFields.put(storedField, new DocumentField(storedField, storedValues));
        }
    }

    static boolean hasSequentialDocs(DocIdToIndex[] docs) {
        return docs.length > 0 && docs[docs.length - 1].docId - docs[0].docId == docs.length - 1;
    }

    static class DocIdToIndex
    implements Comparable<DocIdToIndex> {
        final int docId;
        final int index;

        DocIdToIndex(int docId, int index) {
            this.docId = docId;
            this.index = index;
        }

        @Override
        public int compareTo(DocIdToIndex o) {
            return Integer.compare(this.docId, o.docId);
        }
    }
}

