/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.HashSet;
import java.util.Set;

public class AnalysisPolicy
extends Policy {
    private final Set<URL> locations = new HashSet<URL>();

    public AnalysisPolicy() {
        try {
            this.addRestrictedCodeBase("/groovy/shell");
            this.addRestrictedCodeBase("/groovy/script");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public AnalysisPolicy(String ... codeBases) throws MalformedURLException {
        for (String codeBase : codeBases) {
            this.addRestrictedCodeBase(codeBase);
        }
    }

    public void addRestrictedCodeBase(String codeBase) throws MalformedURLException {
        this.addRestrictedLocation(new URL("file", "", codeBase));
    }

    public void addRestrictedLocation(URL location) {
        this.locations.add(location);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions p = new Permissions();
        if (!this.locations.contains(codeSource.getLocation())) {
            p.add(new AllPermission());
        }
        return p;
    }
}

