/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.Module;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class FormValidator {
    private static final Logger LOG = Logger.getLogger(FormValidator.class.getName());
    private final JsonSchema jsonSchema;
    private final ObjectMapper mapper = new ObjectMapper();

    public FormValidator() {
        this(Module.getInstance().getModuleBundle());
    }

    public FormValidator(Bundle bundle) {
        this(bundle, "formConfig-1.json");
    }

    public FormValidator(Bundle bundle, String fileName) {
        this(JsonDefaultsUtil.loadJsonFileAsString((Bundle)bundle, (String)fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormValidator(String jsonSchemaAsString) {
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JsonSchemaFactory.class.getClassLoader());
            JsonSchemaFactory validatorFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
            this.jsonSchema = validatorFactory.getSchema(jsonSchemaAsString);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    public Set<ValidationMessage> validate(Form form) {
        LOG.finest("validate");
        Set validationMessages = this.jsonSchema.validate(this.mapper.valueToTree(form.getConfig()));
        if (validationMessages.size() > 0) {
            LOG.warning("found " + validationMessages.size() + " validation errors");
        }
        return validationMessages;
    }
}

