/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import de.virtimo.bpc.module.forms.Form;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SimpleForm
implements Form {
    private static final Logger LOG = Logger.getLogger(SimpleForm.class.getName());
    private static final String FORM_METADATA = "metaData";
    private String id;
    private int version;
    private String name;
    private Map<String, Object> config = new LinkedHashMap<String, Object>();
    private Date timestamp;

    public SimpleForm() {
    }

    public SimpleForm(String id, int version, String name, Map<String, Object> config) {
        this(id, version, name, config, new Date());
    }

    public SimpleForm(String id, int version, String name, Map<String, Object> config, Date timestamp) {
        this.setId(id);
        this.setVersion(version);
        this.setName(name);
        this.setConfig(config);
        this.setTimestamp(timestamp);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
        this.updateConfigMetaData("id", id);
    }

    public void setVersion(int version) {
        this.version = version;
        this.updateConfigMetaData("version", version);
    }

    public void setName(String name) {
        this.name = name;
        this.updateConfigMetaData("name", name);
    }

    public void setConfig(Map<String, Object> config) {
        if (config != null) {
            this.config = config;
            this.updateConfigMetaData("id", this.id);
            this.updateConfigMetaData("version", this.version);
            this.updateConfigMetaData("name", this.name);
        }
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleForm that = (SimpleForm)o;
        if (this.version != that.version) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "SimpleForm{id='" + this.id + "', version=" + this.version + ", name='" + this.name + "'}";
    }

    private void updateConfigMetaData(String key, Object value) {
        if (this.config != null && key != null && value != null) {
            if (!this.config.containsKey(FORM_METADATA) || !(this.config.get(FORM_METADATA) instanceof Map)) {
                this.config.put(FORM_METADATA, new LinkedHashMap());
            }
            ((Map)this.config.get(FORM_METADATA)).put(key, value);
        }
    }
}

