@echo off

rem ###############################################################
rem # Copyright (c) Virtimo AG, Germany.
rem # https://www.virtimo.de
rem # All rights reserved.
rem #
rem # Script to start OpenSearch and Karaf
rem ##############################################################

setlocal
set CONSOLE_MODE=%1
set CURRENT_DIR=%CD%
for %%i in ("%~dp0..") do set "BPC_DIR=%%~fi"
set "TAB=   "
goto check_console

rem Help function
:show_help
echo Starts BPC OpenSearch and Karaf
echo Usage: start_bpc.bat [--console]
echo(
echo %TAB%%TAB%-h, --help 	Display this help and exit
echo(
echo %TAB%%TAB%--console   	An optional parameter to open Karaf in active console session
echo 		        By default Karaf opens without an active console session
echo(
echo See also https://docs.virtimo.net/de/bpc-docs/latest/core/admin/operation/start-stop.html
EXIT /B 0

:check_console
rem Display help if -h,--help or any other parameters are passed
set _TEMPVAR=false
if "%CONSOLE_MODE%" == "-h" set _TEMPVAR=true
if "%CONSOLE_MODE%" == "--help" set _TEMPVAR=true

if %_TEMPVAR% == true (
    call :show_help
    goto end
)

if "%CONSOLE_MODE%" NEQ "" (
	if "%CONSOLE_MODE%" NEQ "--console"  (
		call :show_help
		goto end
	)
)

rem ######################
rem # Start BPC components
rem ######################

set OPENSEARCH_PID="%BPC_DIR%\opensearch\bin\opensearch.pid"
set EXECUTABLE_OPENSEARCH="%BPC_DIR%\opensearch\bin\opensearch.bat" -p %OPENSEARCH_PID%
set KARAF_STATUS="%BPC_DIR%\karaf\bin\status.bat"

:CheckKarafRootInstance
    set ROOT_INSTANCE_RUNNING=false
    if exist "%BPC_DIR%\karaf\instances\instance.properties" (
        for /f "delims=" %%x in ( 'findstr "item.0.pid" "%BPC_DIR%\karaf\instances\instance.properties" ' ) do @set pid=%%x
    )
    set ROOT_INSTANCE_PID=%pid:~13%
    SET CHECK_RUNNING_CONDITION=true
    if "%ROOT_INSTANCE_PID%" == "~13" SET CHECK_RUNNING_CONDITION=false
        if "%ROOT_INSTANCE_PID%" == "0" SET CHECK_RUNNING_CONDITION=false
        if "%CHECK_RUNNING_CONDITION%" == "true" (
            tasklist /FI "PID eq %ROOT_INSTANCE_PID%" 2>NUL | find /I /N "java.exe" > NUL
            if not errorlevel 1 set ROOT_INSTANCE_RUNNING=true
        )

rem ##################
rem # Start OpenSearch
rem ##################

if not exist %OPENSEARCH_PID% goto notExists

:fileExists

SET /P PID_VALUE=<%OPENSEARCH_PID%
tasklist | findstr /r "%PID_VALUE%">NUL
if %ERRORLEVEL% == 0 (
    echo OpenSearch already running
    goto startKaraf
)

:notExists
echo Starting OpenSearch ...
start "OpenSearch" cmd /c "%EXECUTABLE_OPENSEARCH%"
echo OpenSearch started

rem #############
rem # Start Karaf
rem #############

:startKaraf
rem Start Karaf
SET IS_RUNNABLE=false
if "%ROOT_INSTANCE_RUNNING%" == "false" SET IS_RUNNABLE=true
if "%IS_RUNNABLE%" == "true" (
    echo Starting Karaf ...
    if "%CONSOLE_MODE%" == "--console" (
        rem foreground
        start "Karaf" /MAX cmd /c "%BPC_DIR%\karaf\bin\karaf.bat"
    ) else (
        rem background
        start "Karaf" /MAX cmd /c "%BPC_DIR%\karaf\bin\start.bat"
        echo Karaf Started
    )
) else (
    echo Karaf already running
)

:end

cd %CURRENT_DIR%
