/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirectoryManager;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.AugmenterInvokerImpl;
import org.apache.aries.jndi.DirObjectFactoryHelper;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;

public class OSGiObjectFactoryBuilder
implements ObjectFactoryBuilder,
ObjectFactory,
DirObjectFactory {
    private BundleContext defaultContext;

    public OSGiObjectFactoryBuilder(BundleContext ctx) {
        this.defaultContext = ctx;
    }

    @Override
    public ObjectFactory createObjectFactory(Object obj, Hashtable<?, ?> environment) throws NamingException {
        return this;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        BundleContext callerContext;
        if (environment == null) {
            environment = new Hashtable();
        }
        if ((callerContext = this.getCallerBundleContext(environment)) == null) {
            return obj;
        }
        DirObjectFactoryHelper helper = new DirObjectFactoryHelper(this.defaultContext, callerContext);
        return helper.getObjectInstance(obj, name, nameCtx, environment);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        BundleContext callerContext;
        if (environment == null) {
            environment = new Hashtable();
        }
        if ((callerContext = this.getCallerBundleContext(environment)) == null) {
            return obj;
        }
        DirObjectFactoryHelper helper = new DirObjectFactoryHelper(this.defaultContext, callerContext);
        return helper.getObjectInstance(obj, name, nameCtx, environment, attrs);
    }

    private BundleContext getCallerBundleContext(Hashtable<?, ?> environment) throws NamingException {
        AugmenterInvokerImpl.getInstance().augmentEnvironment(environment);
        BundleContext context = Utils.getBundleContext(environment, NamingManager.class);
        if (context == null) {
            context = Utils.getBundleContext(environment, DirectoryManager.class);
        }
        AugmenterInvokerImpl.getInstance().unaugmentEnvironment(environment);
        return context;
    }
}

