/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;

public class WebsocketMessageForFrontendSession
implements WebsocketMessage {
    public static final String PREFIX = "WebsocketMessageForFrontendSession:::";
    private final String sessionId;
    private final String jsonMsg;

    public WebsocketMessageForFrontendSession(String sessionId, String jsonMsg) {
        this.sessionId = sessionId;
        this.jsonMsg = jsonMsg;
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static WebsocketMessageForFrontendSession createFromMessage(String websocketMessage) {
        String msgWithoutPrefix = websocketMessage.substring(PREFIX.length());
        String sessionId = msgWithoutPrefix.substring(0, msgWithoutPrefix.indexOf(":::"));
        String jsonMsg = msgWithoutPrefix.substring((sessionId + ":::").length());
        return new WebsocketMessageForFrontendSession(sessionId, jsonMsg);
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        return PREFIX + this.sessionId + ":::" + this.jsonMsg;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getMessage() {
        return this.jsonMsg;
    }

    public String toString() {
        return "WebsocketMessageForFrontendSession{sessionId='" + this.sessionId + "', jsonMsg='" + this.jsonMsg + "'}";
    }
}

