/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject.spi;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.inject.Binder;
import org.opensearch.common.inject.Scope;
import org.opensearch.common.inject.spi.Element;
import org.opensearch.common.inject.spi.ElementVisitor;

@PublicApi(since="1.0.0")
public final class ScopeBinding
implements Element {
    private final Object source;
    private final Class<? extends Annotation> annotationType;
    private final Scope scope;

    ScopeBinding(Object source, Class<? extends Annotation> annotationType, Scope scope) {
        this.source = Objects.requireNonNull(source, "source");
        this.annotationType = Objects.requireNonNull(annotationType, "annotationType");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindScope(this.annotationType, this.scope);
    }
}

