/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Optional;
import org.opensearch.Version;
import org.opensearch.common.lease.Releasable;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.TransportChannel;

public class TaskTransportChannel
implements TransportChannel {
    private final TransportChannel channel;
    private final Releasable onTaskFinished;

    TaskTransportChannel(TransportChannel channel, Releasable onTaskFinished) {
        this.channel = channel;
        this.onTaskFinished = onTaskFinished;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfileName();
    }

    @Override
    public String getChannelType() {
        return this.channel.getChannelType();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try {
            this.onTaskFinished.close();
        }
        finally {
            this.channel.sendResponse(response);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.onTaskFinished.close();
        }
        finally {
            this.channel.sendResponse(exception);
        }
    }

    @Override
    public Version getVersion() {
        return this.channel.getVersion();
    }

    public TransportChannel getChannel() {
        return this.channel;
    }

    @Override
    public <T> Optional<T> get(String name, Class<T> clazz) {
        return this.getChannel().get(name, clazz);
    }
}

