/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.collector.log;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.decanter.collector.utils.PropertiesPreparator;
import org.apache.log4j.MDC;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.decanter.collector.log", property={"org.ops4j.pax.logging.appender.name=DecanterLogCollectorAppender", "name=log"}, immediate=true)
public class LogCollector
implements PaxAppender {
    @Reference
    public EventAdmin dispatcher;
    private static final String MDC_IN_LOG_COLLECTOR = "inLogCollector";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCollector.class);
    private static final Pattern PATTERN = Pattern.compile("[^A-Za-z0-9]");
    private Dictionary<String, Object> properties;
    protected String[] excludedCategories;
    protected String[] includedCategories;
    protected String[] locationDisabledCategories;

    @Activate
    public void activate(ComponentContext context) {
        this.properties = context.getProperties();
        if (this.properties.get("ignored.categories") != null) {
            this.excludedCategories = ((String)this.properties.get("ignored.categories")).split(",");
        }
        if (this.properties.get("excluded.categories") != null) {
            this.excludedCategories = ((String)this.properties.get("excluded.categories")).split(",");
        }
        if (this.properties.get("included.categories") != null) {
            this.includedCategories = ((String)this.properties.get("included.categories")).split(",");
        }
        if (this.properties.get("location.disabled") != null) {
            this.locationDisabledCategories = ((String)this.properties.get("location.disabled")).split(",");
        }
    }

    public void doAppend(PaxLoggingEvent event) {
        try {
            if (MDC.get((String)MDC_IN_LOG_COLLECTOR) != null) {
                return;
            }
            MDC.put((String)MDC_IN_LOG_COLLECTOR, (Object)"true");
            this.appendInternal(event);
        }
        catch (Exception e) {
            LOGGER.warn("Error while appending event", (Throwable)e);
        }
        finally {
            MDC.remove((String)MDC_IN_LOG_COLLECTOR);
        }
    }

    protected void appendInternal(PaxLoggingEvent event) throws Exception {
        String[] throwableAr;
        if (this.includedCategories != null && !this.filterCategory(event.getLoggerName(), this.includedCategories)) {
            LOGGER.debug("{} logger is not in the included list", (Object)event.getLoggerName());
            return;
        }
        if (this.filterCategory(event.getLoggerName(), this.excludedCategories)) {
            LOGGER.debug("{} logger is ignored by the log collector", (Object)event.getLoggerName());
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", "log");
        data.put("timestamp", event.getTimeStamp());
        data.put("loggerClass", event.getFQNOfLoggerClass());
        data.put("loggerName", event.getLoggerName());
        data.put("threadName", event.getThreadName());
        data.put("message", event.getMessage());
        data.put("level", event.getLevel() != null ? event.getLevel().toString() : "default");
        data.put("renderedMessage", event.getRenderedMessage());
        data.put("MDC", event.getProperties());
        if (this.locationDisabledCategories == null || !this.filterCategory(event.getLoggerName(), this.locationDisabledCategories)) {
            this.putLocation(data, event.getLocationInformation());
        }
        if ((throwableAr = event.getThrowableStrRep()) != null) {
            data.put("throwable", this.join(throwableAr));
        }
        PropertiesPreparator.prepare(data, this.properties);
        String loggerName = event.getLoggerName();
        if (loggerName == null || loggerName.isEmpty()) {
            loggerName = "default";
        }
        String topic = this.properties.get("event.topics") != null ? (String)this.properties.get("event.topics") : "decanter/collect/log/";
        this.dispatcher.postEvent(new Event(topic + this.cleanLoggerName(loggerName), data));
    }

    protected final String cleanLoggerName(String loggerName) {
        Matcher matcher = PATTERN.matcher(loggerName);
        if (matcher.find()) {
            return matcher.replaceAll("_");
        }
        return loggerName;
    }

    private void putLocation(Map<String, Object> data, PaxLocationInfo loc) {
        if (loc != null) {
            data.put("loc.class", loc.getClassName());
            data.put("loc.file", loc.getFileName());
            data.put("loc.line", loc.getLineNumber());
            data.put("loc.method", loc.getMethodName());
        }
    }

    private Object join(String[] throwableAr) {
        StringBuilder builder = new StringBuilder();
        for (String line : throwableAr) {
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    protected boolean filterCategory(String loggerName, String[] filterCategories) {
        if (loggerName == null) {
            return true;
        }
        if (filterCategories != null) {
            for (String cat : filterCategories) {
                if (!loggerName.matches(cat)) continue;
                return true;
            }
        }
        return false;
    }
}

