/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.url.ServiceRegistryContext;
import org.osgi.framework.BundleContext;

public class OsgiURLContextFactory
implements ObjectFactory {
    private BundleContext callerContext;

    public OsgiURLContextFactory(BundleContext callerContext) {
        this.callerContext = callerContext;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null) {
            return new ServiceRegistryContext(this.callerContext, environment);
        }
        if (obj instanceof String) {
            return this.findAny(environment, (String)obj);
        }
        if (obj instanceof String[]) {
            return this.findAny(environment, (String[])obj);
        }
        return null;
    }

    private Object findAny(Hashtable<?, ?> environment, String ... urls) throws ConfigurationException, NamingException {
        if (urls.length == 0) {
            throw new ConfigurationException("0");
        }
        ServiceRegistryContext context = new ServiceRegistryContext(this.callerContext, environment);
        try {
            NamingException ne = null;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    Object object = context.lookup(urls[i]);
                    return object;
                }
                catch (NamingException e) {
                    ne = e;
                    continue;
                }
            }
            throw ne;
        }
        finally {
            context.close();
        }
    }
}

