/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.karaf.commands;

import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.ops4j.pax.web.karaf.commands.WebCommand;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.views.ReportWebContainerView;

@Command(scope="web", name="servlet-list", description="Lists all available servlets.")
@Service
public class ServletListCommand
extends WebCommand {
    @Option(name="-v", aliases={"--verbose"})
    private boolean verbose = false;

    @Override
    public void doExecute(WebContainer container) {
        ReportWebContainerView view = (ReportWebContainerView)container.adapt(ReportWebContainerView.class);
        if (view == null) {
            System.err.println("Can't obtain a reference to WebContainer/HttpService.");
            return;
        }
        Set servlets = view.listServlets();
        ShellTable table = new ShellTable();
        table.column(new Col("Bundle ID"));
        table.column(new Col("Name"));
        table.column(new Col("Class"));
        table.column(new Col("Context Path(s)"));
        table.column(new Col("URLs"));
        table.column(new Col("Type"));
        if (this.verbose) {
            table.column(new Col("Context Filter"));
        }
        servlets.forEach(s -> {
            long bundleId = s.getBundle().getBundleId();
            String name = s.getServletName();
            String cls = s.getServletClass();
            String contexts = String.join((CharSequence)", ", s.getContexts());
            String mappings = String.join((CharSequence)", ", s.getMapping());
            String type = s.getType();
            String filter = s.getContextFilter();
            if (this.verbose) {
                table.addRow().addContent(new Object[]{bundleId, name, cls, contexts, mappings, type, filter});
            } else {
                table.addRow().addContent(new Object[]{bundleId, name, cls, contexts, mappings, type});
            }
        });
        table.print(System.out, true);
    }
}

